/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewTypeLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameRefactoringSupport;
import org.jetbrains.kotlin.idea.refactoring.rename.LostDefaultValuesInOverridingFunctionUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.rename.UnresolvableConventionViolationUsageInfo;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a>\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0013\u0012\u0004\u0012\u00020\u00060\u0017\u001aA\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u000e\b\u0004\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001fH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 \u001a\f\u0010!\u001a\u00020\u0006*\u00020\u0002H\u0002\u001a&\u0010\"\u001a\u0004\u0018\u00010#*\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\f\u0010$\u001a\u00020\u001c*\u00020\u0011H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"useScopeForRename", "Lcom/intellij/psi/search/SearchScope;", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getUseScopeForRename", "(Lorg/jetbrains/kotlin/psi/KtParameter;)Lcom/intellij/psi/search/SearchScope;", "checkConflictsAndReplaceUsageInfos", "", "element", "Lcom/intellij/psi/PsiElement;", "allRenames", "", "", "result", "", "Lcom/intellij/usageView/UsageInfo;", "checkSuperMethodsWithPopup", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "deepestSuperMethods", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "action", "Lkotlin/Function1;", "runProcessWithProgressSynchronously", "T", "progressTitle", "canBeCancelled", "", "project", "Lcom/intellij/openapi/project/Project;", "Lkotlin/Function0;", "(Ljava/lang/String;ZLcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dropDefaultValue", "getOverriddenFunctionWithDefaultValues", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isAbstract", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\ncommonRenameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,181:1\n1603#2,9:182\n1855#2:191\n1856#2:193\n1612#2:194\n800#2,11:195\n288#2:206\n1747#2,3:207\n289#2:210\n1603#2,9:212\n1855#2:221\n1856#2:223\n1612#2:224\n1747#2,3:225\n1747#2,3:228\n1#3:192\n1#3:222\n76#4:211\n*S KotlinDebug\n*F\n+ 1 commonRenameUtils.kt\norg/jetbrains/kotlin/idea/refactoring/rename/CommonRenameUtilsKt\n*L\n102#1:182,9\n102#1:191\n102#1:193\n102#1:194\n106#1:195,11\n107#1:206\n107#1:207,3\n107#1:210\n149#1:212,9\n149#1:221\n149#1:223\n149#1:224\n150#1:225,3\n151#1:228,3\n102#1:192\n149#1:222\n141#1:211\n*E\n"})
public final class CommonRenameUtilsKt {
    @NotNull
    public static final SearchScope getUseScopeForRename(@NotNull KtParameter $this$useScopeForRename) {
        KtFunction owner;
        Intrinsics.checkNotNullParameter((Object)$this$useScopeForRename, (String)"<this>");
        KtDeclarationWithBody ktDeclarationWithBody = $this$useScopeForRename.getOwnerFunction();
        KtFunction ktFunction = owner = ktDeclarationWithBody instanceof KtFunction ? (KtFunction)ktDeclarationWithBody : null;
        Object object = ktFunction != null ? ktFunction.getUseScope() : null;
        if (object == null) {
            SearchScope searchScope2 = $this$useScopeForRename.getUseScope();
            object = searchScope2;
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"useScope");
        }
        return object;
    }

    public static final <T> T runProcessWithProgressSynchronously(@NlsContexts.DialogMessage @NotNull String progressTitle, boolean canBeCancelled, @NotNull Project project2, @NotNull Function0<? extends T> action2) {
        Intrinsics.checkNotNullParameter((Object)progressTitle, (String)"progressTitle");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        boolean $i$f$runProcessWithProgressSynchronously = false;
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(action2){
            final /* synthetic */ Function0<T> $action;
            {
                this.$action = $action;
            }

            public final T compute() {
                return (T)this.$action.invoke();
            }
        }, progressTitle, canBeCancelled, project2);
    }

    public static final void checkConflictsAndReplaceUsageInfos(@NotNull PsiElement element3, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        KtNamedFunction ktNamedFunction = CommonRenameUtilsKt.getOverriddenFunctionWithDefaultValues(element3, allRenames);
        if (ktNamedFunction != null) {
            KtNamedFunction baseFunction = ktNamedFunction;
            boolean bl = false;
            collection = result2;
            PsiElement psiElement2 = LightClassUtilsKt.getUnwrapped((PsiElement)element3);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
            collection.add(new LostDefaultValuesInOverridingFunctionUsageInfo((KtNamedFunction)psiElement2, baseFunction));
        }
        ListIterator<UsageInfo> usageIterator = result2.listIterator();
        while (usageIterator.hasNext()) {
            PsiElement referencedElement;
            PsiElement refElement2;
            AbstractKtReference ref;
            UsageInfo bl = usageIterator.next();
            MoveRenameUsageInfo moveRenameUsageInfo = bl instanceof MoveRenameUsageInfo ? (MoveRenameUsageInfo)bl : null;
            if (moveRenameUsageInfo == null) continue;
            MoveRenameUsageInfo usageInfo = moveRenameUsageInfo;
            collection = usageInfo.getReference();
            AbstractKtReference abstractKtReference = collection instanceof AbstractKtReference ? (AbstractKtReference)collection : null;
            if (abstractKtReference == null || (ref = abstractKtReference).canRename() || usageInfo.getElement() == null || usageInfo.getReferencedElement() == null) continue;
            usageIterator.set((UsageInfo)new UnresolvableConventionViolationUsageInfo(refElement2, referencedElement));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final KtNamedFunction getOverriddenFunctionWithDefaultValues(PsiElement $this$getOverriddenFunctionWithDefaultValues, Map<? extends PsiElement, String> allRenames) {
        Object element$iv;
        Object v2;
        boolean bl;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapNotNull$iv = allRenames.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        Iterable $this$forEach$iv$iv$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiElement it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement2 = it;
            if ((psiElement2 != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement2) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elementsToRename = (List)destination$iv$iv;
        PsiElement psiElement3 = LightClassUtilsKt.getUnwrapped((PsiElement)$this$getOverriddenFunctionWithDefaultValues);
        if (!(psiElement3 instanceof KtNamedFunction)) return null;
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
        if (ktNamedFunction == null) {
            return null;
        }
        KtNamedFunction function2 = ktNamedFunction;
        List<PsiElement> overridenFunctions = KotlinRenameRefactoringSupport.Companion.getInstance().getAllOverridenFunctions(function2);
        Iterable iterable2 = overridenFunctions;
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$mapNotNullTo22 = iterable2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv2;
        boolean $i$f$firstOrNull = false;
        Iterator iterator3 = iterable3.iterator();
        do {
            if (!iterator3.hasNext()) {
                v2 = null;
                return v2;
            }
            element$iv = iterator3.next();
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl5 = false;
            if (!elementsToRename.contains(it)) {
                boolean bl6;
                block10: {
                    List list2 = it.getValueParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.valueParameters");
                    Iterable $this$any$iv = list2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl6 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            KtParameter it2 = (KtParameter)element$iv2;
                            boolean bl7 = false;
                            if (!it2.hasDefaultValue()) continue;
                            bl6 = true;
                            break block10;
                        }
                        bl6 = false;
                    }
                }
                if (bl6) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v2 = element$iv;
        return v2;
    }

    private static final void dropDefaultValue(KtParameter $this$dropDefaultValue) {
        PsiElement psiElement2 = $this$dropDefaultValue.getEqualsToken();
        if (psiElement2 == null) {
            return;
        }
        PsiElement from = psiElement2;
        KtExpression ktExpression = $this$dropDefaultValue.getDefaultValue();
        PsiElement to2 = ktExpression == null ? from : (PsiElement)ktExpression;
        $this$dropDefaultValue.deleteChildRange(from, to2);
    }

    private static final boolean isAbstract(KtNamedDeclaration $this$isAbstract) {
        boolean bl;
        if ($this$isAbstract.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
            bl = true;
        } else {
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)$this$isAbstract));
            KtClass ktClass2 = ktClassOrObject instanceof KtClass ? (KtClass)ktClassOrObject : null;
            boolean bl2 = ktClass2 != null ? ktClass2.isInterface() : false;
            bl = !bl2 ? false : ($this$isAbstract instanceof KtProperty ? ((KtProperty)$this$isAbstract).getInitializer() == null && ((KtProperty)$this$isAbstract).getDelegate() == null && ((KtProperty)$this$isAbstract).getAccessors().isEmpty() : ($this$isAbstract instanceof KtNamedFunction ? !((KtNamedFunction)$this$isAbstract).hasBody() : false));
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkSuperMethodsWithPopup(@NotNull KtNamedDeclaration declaration2, @NotNull List<? extends PsiElement> deepestSuperMethods2, @NotNull Editor editor2, @NotNull Function1<? super List<? extends PsiElement>, Unit> action2) {
        Object element$iv3;
        boolean bl;
        boolean hasJavaMethods;
        int kindIndex;
        boolean isAbstract;
        PsiElement superClass;
        PsiElement superMethod;
        block17: {
            boolean bl2;
            List unwrappedSupers;
            block16: {
                void $this$mapNotNullTo$iv$iv;
                int n;
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                Intrinsics.checkNotNullParameter(deepestSuperMethods2, (String)"deepestSuperMethods");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                if (deepestSuperMethods2.isEmpty()) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                superMethod = (PsiElement)CollectionsKt.first(deepestSuperMethods2);
                PsiElement psiElement2 = superMethod;
                Pair pair = psiElement2 instanceof PsiMember ? TuplesKt.to((Object)((PsiMember)superMethod).getContainingClass(), (Object)((PsiMember)superMethod).hasModifierProperty("abstract")) : (psiElement2 instanceof KtNamedDeclaration ? TuplesKt.to((Object)KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)superMethod)), (Object)CommonRenameUtilsKt.isAbstract((KtNamedDeclaration)superMethod)) : null);
                if (pair == null) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                Pair pair2 = pair;
                superClass = (PsiElement)pair2.component1();
                isAbstract = (Boolean)pair2.component2();
                if (superClass == null) {
                    action2.invoke((Object)CollectionsKt.listOf((Object)declaration2));
                    return;
                }
                boolean $i$f$isUnitTestMode = false;
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    action2.invoke(deepestSuperMethods2);
                    return;
                }
                KtNamedDeclaration ktNamedDeclaration = declaration2;
                if (ktNamedDeclaration instanceof KtNamedFunction) {
                    n = 1;
                } else if (ktNamedDeclaration instanceof KtProperty ? true : ktNamedDeclaration instanceof KtParameter) {
                    n = 2;
                } else {
                    return;
                }
                kindIndex = n;
                Iterable $this$mapNotNull$iv = deepestSuperMethods2;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiNamedElement it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl4 = false;
                    if (LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)it) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                unwrappedSupers = (List)destination$iv$iv;
                Iterable $this$any$iv = unwrappedSupers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        PsiNamedElement it = (PsiNamedElement)element$iv2;
                        boolean bl6 = false;
                        if (!(it instanceof PsiMethod)) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = false;
                }
            }
            hasJavaMethods = bl2;
            Iterable $this$any$iv = unwrappedSupers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv3 : $this$any$iv) {
                    PsiNamedElement it = (PsiNamedElement)element$iv3;
                    boolean bl7 = false;
                    if (!(it instanceof KtNamedDeclaration)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean hasKtMembers = bl;
        int superKindIndex = hasJavaMethods && hasKtMembers ? 3 : (hasJavaMethods ? 4 : kindIndex);
        Object[] element$iv2 = new Object[]{superKindIndex + (deepestSuperMethods2.size() > 1 ? 10 : 0)};
        String renameBase = KotlinBundle.message("rename.base.0", element$iv2);
        element$iv3 = new Object[]{kindIndex};
        String renameCurrent = KotlinBundle.message("rename.only.current.0", element$iv3);
        Object[] objectArray = new Object[4];
        String string2 = declaration2.getName();
        if (string2 == null) {
            string2 = "";
        }
        objectArray[0] = string2;
        objectArray[1] = isAbstract ? 1 : 2;
        Intrinsics.checkNotNullExpressionValue((Object)ElementDescriptionUtil.getElementDescription((PsiElement)superMethod, (ElementDescriptionLocation)((ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE)), (String)"getElementDescription(su\u2026iewTypeLocation.INSTANCE)");
        Intrinsics.checkNotNullExpressionValue((Object)SymbolPresentationUtil.getSymbolPresentableText((PsiElement)superClass), (String)"getSymbolPresentableText(superClass)");
        String title = KotlinBundle.message("rename.declaration.title.0.implements.1.2.of.3", objectArray);
        objectArray = new String[]{renameBase, renameCurrent};
        JBPopupFactory.getInstance().createPopupChooserBuilder(CollectionsKt.listOf((Object[])objectArray)).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(arg_0 -> CommonRenameUtilsKt.checkSuperMethodsWithPopup$lambda$7((Function1)new Function1<String, Unit>(renameBase, deepestSuperMethods2, declaration2, action2){
            final /* synthetic */ String $renameBase;
            final /* synthetic */ List<PsiElement> $deepestSuperMethods;
            final /* synthetic */ KtNamedDeclaration $declaration;
            final /* synthetic */ Function1<List<? extends PsiElement>, Unit> $action;
            {
                this.$renameBase = $renameBase;
                this.$deepestSuperMethods = $deepestSuperMethods;
                this.$declaration = $declaration;
                this.$action = $action;
                super(1);
            }

            public final void invoke(@Nullable String value2) {
                if (value2 == null) {
                    return;
                }
                List chosenElements = Intrinsics.areEqual((Object)value2, (Object)this.$renameBase) ? CollectionsKt.plus((Collection)this.$deepestSuperMethods, (Object)this.$declaration) : CollectionsKt.listOf((Object)this.$declaration);
                this.$action.invoke((Object)chosenElements);
            }
        }, arg_0)).createPopup().showInBestPositionFor(editor2);
    }

    private static final void checkSuperMethodsWithPopup$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$dropDefaultValue(KtParameter $receiver) {
        CommonRenameUtilsKt.dropDefaultValue($receiver);
    }
}

