/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.reporter;

import com.intellij.diagnostic.ReportMessages;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.PluginUpdateStatus;
import com.intellij.ide.plugins.StandalonePluginUpdateChecker;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.SubmittedReportInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import java.awt.Component;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.List;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUpdater;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.reporter.ITNReporterCompat;
import org.jetbrains.kotlin.idea.reporter.KotlinReportSubmitter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J?\u0010\u0016\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\t2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001c0\u001bH\u0016\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter;", "Lorg/jetbrains/kotlin/idea/reporter/ITNReporterCompat;", "()V", "hasLatestVersion", "", "hasUpdate", "showDialog", "", "parent", "Ljava/awt/Component;", "message", "", "title", "options", "", "defaultOptionIndex", "icon", "Ljavax/swing/Icon;", "(Ljava/awt/Component;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;ILjavax/swing/Icon;)I", "showErrorInRelease", "event", "Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;", "submitCompat", "events", "additionalInfo", "parentComponent", "consumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/openapi/diagnostic/SubmittedReportInfo;", "([Lcom/intellij/openapi/diagnostic/IdeaLoggingEvent;Ljava/lang/String;Ljava/awt/Component;Lcom/intellij/util/Consumer;)Z", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinReportSubmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,274:1\n84#2:275\n76#2:276\n84#2:277\n*S KotlinDebug\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter\n*L\n165#1:275\n170#1:276\n212#1:277\n*E\n"})
public final class KotlinReportSubmitter
extends ITNReporterCompat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasUpdate;
    private boolean hasLatestVersion;
    @NotNull
    private static final String KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY = "kotlin.fatal.error.notification";
    @NotNull
    private static final String IDEA_FATAL_ERROR_NOTIFICATION_PROPERTY = "idea.fatal.error.notification";
    @NotNull
    private static final String DISABLED_VALUE = "disabled";
    @NotNull
    private static final String ENABLED_VALUE = "enabled";
    @NotNull
    private static final String KOTLIN_PLUGIN_RELEASE_DATE = "kotlin.plugin.releaseDate";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static volatile ThreeState isFatalErrorReportingDisabledInRelease;
    @NotNull
    private static final Lazy<Boolean> isIdeaAndKotlinRelease$delegate;
    private static final int NUMBER_OF_REPORTING_DAYS_FROM_RELEASE = 7;
    @NotNull
    private static final Lazy<DateTimeFormatter> RELEASE_DATE_FORMATTER$delegate;

    public boolean showErrorInRelease(@NotNull IdeaLoggingEvent event) {
        boolean kotlinNotificationEnabled;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$isApplicationInternalMode = false;
        if (ApplicationManager.getApplication().isInternal()) {
            return true;
        }
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (this.hasUpdate) {
            return false;
        }
        boolean bl = kotlinNotificationEnabled = !Intrinsics.areEqual((Object)DISABLED_VALUE, (Object)System.getProperty(KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY, ENABLED_VALUE));
        if (!kotlinNotificationEnabled) {
            return false;
        }
        if (!KotlinReportSubmitter.Companion.isIdeaAndKotlinRelease()) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[isFatalErrorReportingDisabledInRelease.ordinal()]) {
            case 1 -> false;
            case 2 -> {
                if (!KotlinReportSubmitter.Companion.isFatalErrorReportingDisabledWithUpdate()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (!KotlinReportSubmitter.Companion.isFatalErrorReportingDisabledWithUpdate()) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean submitCompat(@NotNull IdeaLoggingEvent[] events, @Nullable String additionalInfo, @Nullable Component parentComponent, @NotNull Consumer<? super SubmittedReportInfo> consumer) {
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.hasUpdate) {
            boolean $i$f$isApplicationInternalMode = false;
            if (ApplicationManager.getApplication().isInternal()) {
                return super.submitCompat(events, additionalInfo, parentComponent, consumer);
            }
            return true;
        }
        if (this.hasLatestVersion) {
            return super.submitCompat(events, additionalInfo, parentComponent, consumer);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(parentComponent));
        if (KotlinIdePlugin.INSTANCE.getHasPatchedVersion()) {
            ReportMessages.GROUP.createNotification(KotlinBundle.message("reporter.text.can.t.report.exception.from.patched.plugin", new Object[0]), NotificationType.INFORMATION).setImportant(false).notify(project2);
            return true;
        }
        KotlinPluginUpdater.Companion.getInstance().runUpdateCheck((Function1<? super PluginUpdateStatus, Boolean>)((Function1)new Function1<PluginUpdateStatus, Boolean>(this, events, additionalInfo, parentComponent, consumer){
            final /* synthetic */ KotlinReportSubmitter this$0;
            final /* synthetic */ IdeaLoggingEvent[] $events;
            final /* synthetic */ String $additionalInfo;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ Consumer<? super SubmittedReportInfo> $consumer;
            {
                this.this$0 = $receiver;
                this.$events = $events;
                this.$additionalInfo = $additionalInfo;
                this.$parentComponent = $parentComponent;
                this.$consumer = $consumer;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PluginUpdateStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (status instanceof PluginUpdateStatus.Update) {
                    KotlinReportSubmitter.access$setHasUpdate$p(this.this$0, true);
                    boolean $i$f$isApplicationInternalMode = false;
                    if (ApplicationManager.getApplication().isInternal()) {
                        KotlinReportSubmitter.access$submitCompat$s-1082302682(this.this$0, this.$events, this.$additionalInfo, this.$parentComponent, this.$consumer);
                    }
                    Object[] objectArray = new Object[2];
                    objectArray[0] = KotlinIdePlugin.INSTANCE.getVersion();
                    Intrinsics.checkNotNullExpressionValue((Object)((PluginUpdateStatus.Update)status).getPluginDescriptor().getVersion(), (String)"status.pluginDescriptor.version");
                    String string2 = KotlinBundle.message("reporter.message.text.you.re.running.kotlin.plugin.version", objectArray);
                    objectArray = new String[]{KotlinBundle.message("reporter.button.text.update", new Object[0]), KotlinBundle.message("reporter.button.text.ignore", new Object[0])};
                    int rc = this.this$0.showDialog(this.$parentComponent, string2, KotlinBundle.message("reporter.title.update.kotlin.plugin", new Object[0]), (String[])objectArray, 0, Messages.getInformationIcon());
                    if (rc == 0) {
                        StandalonePluginUpdateChecker.installPluginUpdate$default((StandalonePluginUpdateChecker)KotlinPluginUpdater.Companion.getInstance(), (PluginUpdateStatus.Update)((PluginUpdateStatus.Update)status), null, null, null, (int)14, null);
                    }
                } else {
                    KotlinReportSubmitter.access$setHasLatestVersion$p(this.this$0, true);
                    KotlinReportSubmitter.access$submitCompat$s-1082302682(this.this$0, this.$events, this.$additionalInfo, this.$parentComponent, this.$consumer);
                }
                return false;
            }
        }));
        return true;
    }

    public final int showDialog(@Nullable Component parent2, @Nls @NotNull String message2, @Nls @NotNull String title, @NotNull String[] options2, int defaultOptionIndex, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return parent2 != null ? Messages.showDialog((Component)parent2, (String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon) : Messages.showDialog((String)message2, (String)title, (String[])options2, (int)defaultOptionIndex, (Icon)icon);
    }

    public static final /* synthetic */ void access$setHasUpdate$p(KotlinReportSubmitter $this, boolean bl) {
        $this.hasUpdate = bl;
    }

    public static final /* synthetic */ boolean access$submitCompat$s-1082302682(KotlinReportSubmitter $this, IdeaLoggingEvent[] events, String additionalInfo, Component parentComponent, Consumer consumer) {
        return super.submitCompat(events, additionalInfo, parentComponent, (Consumer<? super SubmittedReportInfo>)consumer);
    }

    public static final /* synthetic */ void access$setHasLatestVersion$p(KotlinReportSubmitter $this, boolean bl) {
        $this.hasLatestVersion = bl;
    }

    static {
        Logger logger = Logger.getInstance(KotlinReportSubmitter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(KotlinReportSubmitter::class.java)");
        LOG = logger;
        isFatalErrorReportingDisabledInRelease = ThreeState.UNSURE;
        isIdeaAndKotlinRelease$delegate = LazyKt.lazy((Function0)Companion.isIdeaAndKotlinRelease.2.INSTANCE);
        RELEASE_DATE_FORMATTER$delegate = LazyKt.lazy((Function0)Companion.RELEASE_DATE_FORMATTER.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\u0012\u0010\u001e\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0002J\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0013\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion;", "", "()V", "DISABLED_VALUE", "", "ENABLED_VALUE", "IDEA_FATAL_ERROR_NOTIFICATION_PROPERTY", "KOTLIN_FATAL_ERROR_NOTIFICATION_PROPERTY", "KOTLIN_PLUGIN_RELEASE_DATE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NUMBER_OF_REPORTING_DAYS_FROM_RELEASE", "", "RELEASE_DATE_FORMATTER", "Ljava/time/format/DateTimeFormatter;", "getRELEASE_DATE_FORMATTER", "()Ljava/time/format/DateTimeFormatter;", "RELEASE_DATE_FORMATTER$delegate", "Lkotlin/Lazy;", "isFatalErrorReportingDisabledInRelease", "Lcom/intellij/util/ThreeState;", "isIdeaAndKotlinRelease", "", "()Z", "isIdeaAndKotlinRelease$delegate", "isFatalErrorReportingDisabled", "releaseDate", "Ljava/time/LocalDate;", "isFatalErrorReportingDisabledWithUpdate", "isFatalErrorReportingWithDefault", "readStoredPluginReleaseDate", "setupReportingFromRelease", "", "writePluginReleaseValue", "date", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinReportSubmitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,274:1\n76#2:275\n*S KotlinDebug\n*F\n+ 1 KotlinReportSubmitter.kt\norg/jetbrains/kotlin/idea/reporter/KotlinReportSubmitter$Companion\n*L\n60#1:275\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isIdeaAndKotlinRelease() {
            Lazy lazy = isIdeaAndKotlinRelease$delegate;
            return (Boolean)lazy.getValue();
        }

        public final void setupReportingFromRelease() {
            boolean $i$f$isUnitTestMode = false;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (!this.isIdeaAndKotlinRelease()) {
                return;
            }
            LocalDate currentPluginReleaseDate = this.readStoredPluginReleaseDate();
            if (currentPluginReleaseDate != null) {
                isFatalErrorReportingDisabledInRelease = this.isFatalErrorReportingDisabled(currentPluginReleaseDate) ? ThreeState.YES : ThreeState.NO;
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(Companion::setupReportingFromRelease$lambda$0);
        }

        private final ThreeState isFatalErrorReportingWithDefault(LocalDate releaseDate) {
            return releaseDate != null ? (this.isFatalErrorReportingDisabled(releaseDate) ? ThreeState.YES : ThreeState.NO) : ThreeState.YES;
        }

        private final boolean isFatalErrorReportingDisabledWithUpdate() {
            LocalDate currentPluginReleaseDate = this.readStoredPluginReleaseDate();
            isFatalErrorReportingDisabledInRelease = this.isFatalErrorReportingWithDefault(currentPluginReleaseDate);
            return isFatalErrorReportingDisabledInRelease == ThreeState.YES;
        }

        private final boolean isFatalErrorReportingDisabled(LocalDate releaseDate) {
            return ChronoUnit.DAYS.between(releaseDate, LocalDate.now()) > 7L;
        }

        private final DateTimeFormatter getRELEASE_DATE_FORMATTER() {
            Lazy lazy = RELEASE_DATE_FORMATTER$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-RELEASE_DATE_FORMATTER>(...)");
            return (DateTimeFormatter)object;
        }

        private final LocalDate readStoredPluginReleaseDate() {
            LocalDate localDate;
            String string2 = PropertiesComponent.getInstance().getValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE);
            if (string2 == null) {
                return null;
            }
            String pluginVersionToReleaseDate = string2;
            String[] stringArray = new String[]{":"};
            List parts2 = StringsKt.split$default((CharSequence)pluginVersionToReleaseDate, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (parts2.size() != 2) {
                localDate = null;
            } else {
                String pluginVersion = (String)parts2.get(0);
                if (!Intrinsics.areEqual((Object)pluginVersion, (Object)KotlinIdePlugin.INSTANCE.getVersion())) {
                    localDate = null;
                } else {
                    LocalDate localDate2;
                    try {
                        String dateString = (String)parts2.get(1);
                        localDate2 = LocalDate.parse(dateString, Companion.getRELEASE_DATE_FORMATTER());
                    }
                    catch (DateTimeParseException e) {
                        localDate2 = null;
                    }
                    localDate = localDate2;
                }
            }
            LocalDate parsedDate = localDate;
            if (parsedDate == null) {
                PropertiesComponent.getInstance().setValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE, null);
            }
            return parsedDate;
        }

        private final void writePluginReleaseValue(LocalDate date) {
            String currentKotlinVersion = KotlinIdePlugin.INSTANCE.getVersion();
            String dateStr = this.getRELEASE_DATE_FORMATTER().format(date);
            PropertiesComponent.getInstance().setValue(KotlinReportSubmitter.KOTLIN_PLUGIN_RELEASE_DATE, currentKotlinVersion + ":" + dateStr);
        }

        private static final void setupReportingFromRelease$lambda$0() {
            LocalDate localDate;
            try {
                localDate = KotlinPluginUpdater.Companion.fetchPluginReleaseDate(KotlinIdePlugin.INSTANCE.getId(), KotlinIdePlugin.INSTANCE.getVersion(), null);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                localDate = null;
            }
            catch (KotlinPluginUpdater.Companion.ResponseParseException e) {
                LOG.error((Throwable)e);
                return;
            }
            LocalDate releaseDate = localDate;
            if (releaseDate != null) {
                Companion.writePluginReleaseValue(releaseDate);
            }
            isFatalErrorReportingDisabledInRelease = Companion.isFatalErrorReportingWithDefault(releaseDate);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

