/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.KotlinScopeUtils;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u001a\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0007\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u000b*\u00020\u0010\u001a\u0012\u0010\u0012\u001a\u00020\u000b*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010\u001a!\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00160\u0007H\u0082\b\u001a.\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"\u001a\n\u0010#\u001a\u00020\u0003*\u00020$\u001a\f\u0010%\u001a\u00020\r*\u00020\u000eH\u0007\u001a\n\u0010&\u001a\u00020\u001d*\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"parenthesisRegex", "Lkotlin/text/Regex;", "findScriptsWithUsages", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtFile;", "isOnlyKotlinSearch", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "allScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lcom/intellij/openapi/project/Project;", "codeUsageScopeRestrictedToKotlinSources", "Lcom/intellij/psi/PsiElement;", "codeUsageScopeRestrictedToProject", "effectiveSearchScope", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "element", "ifNotEmpty", "", "", "action", "isCheapEnoughToSearchConsideringOperators", "Lcom/intellij/psi/search/PsiSearchHelper$SearchCostResult;", "Lcom/intellij/psi/search/PsiSearchHelper;", "name", "", "scope", "fileToIgnoreOccurrencesIn", "Lcom/intellij/psi/PsiFile;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isImportUsage", "Lcom/intellij/psi/PsiReference;", "projectScope", "toHumanReadableString", "kotlin.base.analysis"})
@SourceDebugExtension(value={"SMAP\nsearchUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 searchUtil.kt\norg/jetbrains/kotlin/idea/search/SearchUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,130:1\n53#1:132\n54#1:134\n1#2:131\n1#2:133\n12271#3,2:135\n146#4:137\n*S KotlinDebug\n*F\n+ 1 searchUtil.kt\norg/jetbrains/kotlin/idea/search/SearchUtilKt\n*L\n62#1:132\n62#1:134\n62#1:133\n88#1:135,2\n128#1:137\n*E\n"})
public final class SearchUtilKt {
    @NotNull
    private static final Regex parenthesisRegex = new Regex("( *\\( *)|( *\\) *)|( *, *(?![^\\[]*]))");

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.allScope' instead", replaceWith=@ReplaceWith(expression="this.allScope()", imports={"org.jetbrains.kotlin.idea.base.util.allScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope allScope(@NotNull Project $this$allScope) {
        Intrinsics.checkNotNullParameter((Object)$this$allScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)$this$allScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(this)");
        return globalSearchScope;
    }

    @Deprecated(message="Use 'org.jetbrains.kotlin.idea.base.util.projectScope' instead", replaceWith=@ReplaceWith(expression="this.projectScope()", imports={"org.jetbrains.kotlin.idea.base.util.projectScope"}), level=DeprecationLevel.ERROR)
    @NotNull
    public static final GlobalSearchScope projectScope(@NotNull Project $this$projectScope) {
        Intrinsics.checkNotNullParameter((Object)$this$projectScope, (String)"<this>");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)$this$projectScope);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"projectScope(this)");
        return globalSearchScope;
    }

    private static final void ifNotEmpty(CharSequence $this$ifNotEmpty, Function1<? super CharSequence, Unit> action2) {
        block0: {
            CharSequence charSequence2;
            boolean $i$f$ifNotEmpty = false;
            CharSequence p0 = charSequence2 = $this$ifNotEmpty;
            boolean bl = false;
            CharSequence charSequence3 = !StringsKt.isBlank((CharSequence)p0) ? charSequence2 : null;
            if (charSequence3 == null) break block0;
            action2.invoke((Object)charSequence3);
        }
    }

    @NotNull
    public static final String toHumanReadableString(@NotNull SearchScope $this$toHumanReadableString) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toHumanReadableString, (String)"<this>");
        StringBuilder $this$toHumanReadableString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String scopeText = $this$toHumanReadableString.toString();
        int currentIndent = 0;
        int lastIndex = 0;
        for (MatchResult parenthesis : Regex.findAll$default((Regex)parenthesisRegex, (CharSequence)scopeText, (int)0, (int)2, null)) {
            CharSequence charSequence2;
            CharSequence subSequence;
            CharSequence $this$ifNotEmpty$iv = subSequence = scopeText.subSequence(lastIndex, parenthesis.getRange().getFirst());
            boolean $i$f$ifNotEmpty = false;
            CharSequence p0$iv = charSequence2 = $this$ifNotEmpty$iv;
            boolean bl2 = false;
            if ((!StringsKt.isBlank((CharSequence)p0$iv) ? charSequence2 : null) != null) {
                CharSequence it;
                it = it;
                boolean bl3 = false;
                $this$toHumanReadableString_u24lambda_u241.append(StringsKt.repeat((CharSequence)" ", (int)currentIndent));
                StringBuilder stringBuilder2 = $this$toHumanReadableString_u24lambda_u241.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            }
            String value2 = parenthesis.getValue();
            if (StringsKt.contains$default((CharSequence)value2, (CharSequence)"(", (boolean)false, (int)2, null)) {
                currentIndent += 2;
            } else if (StringsKt.contains$default((CharSequence)value2, (CharSequence)")", (boolean)false, (int)2, null)) {
                currentIndent -= 2;
            }
            lastIndex = parenthesis.getRange().getLast() + 1;
        }
        if (((CharSequence)$this$toHumanReadableString_u24lambda_u241).length() == 0) {
            $this$toHumanReadableString_u24lambda_u241.append(scopeText);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public static final SearchScope effectiveSearchScope(@NotNull ReferencesSearch.SearchParameters $this$effectiveSearchScope, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)$this$effectiveSearchScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3, (Object)$this$effectiveSearchScope.getElementToSearch())) {
            SearchScope searchScope2 = $this$effectiveSearchScope.getEffectiveSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"effectiveSearchScope");
            return searchScope2;
        }
        if ($this$effectiveSearchScope.isIgnoreAccessScope()) {
            SearchScope searchScope3 = $this$effectiveSearchScope.getScopeDeterminedByUser();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope3, (String)"scopeDeterminedByUser");
            return searchScope3;
        }
        SearchScope accessScope = KotlinScopeUtils.useScope(element3);
        SearchScope searchScope4 = $this$effectiveSearchScope.getScopeDeterminedByUser().intersectWith(accessScope);
        Intrinsics.checkNotNullExpressionValue((Object)searchScope4, (String)"scopeDeterminedByUser.intersectWith(accessScope)");
        return searchScope4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isOnlyKotlinSearch(@NotNull SearchScope searchScope2) {
        Intrinsics.checkNotNullParameter((Object)searchScope2, (String)"searchScope");
        if (!(searchScope2 instanceof LocalSearchScope)) return false;
        PsiElement[] psiElementArray = ((LocalSearchScope)searchScope2).getScope();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"searchScope.scope");
        Object[] $this$all$iv = psiElementArray;
        boolean $i$f$all = false;
        int n = 0;
        int n2 = $this$all$iv.length;
        while (n < n2) {
            Object element$iv = $this$all$iv[n];
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            if (!(it.getContainingFile() instanceof KtFile)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToProject(@NotNull PsiElement $this$codeUsageScopeRestrictedToProject) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScopeRestrictedToProject, (String)"<this>");
        Project project2 = $this$codeUsageScopeRestrictedToProject.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        SearchScope searchScope2 = KotlinScopeUtils.projectScope(project2).intersectWith(KotlinScopeUtils.codeUsageScope($this$codeUsageScopeRestrictedToProject));
        Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"project.projectScope().i\u2026ectWith(codeUsageScope())");
        return searchScope2;
    }

    @NotNull
    public static final SearchScope codeUsageScopeRestrictedToKotlinSources(@NotNull PsiElement $this$codeUsageScopeRestrictedToKotlinSources) {
        Intrinsics.checkNotNullParameter((Object)$this$codeUsageScopeRestrictedToKotlinSources, (String)"<this>");
        return KotlinScopeUtils.restrictToKotlinSources(KotlinScopeUtils.codeUsageScope($this$codeUsageScopeRestrictedToKotlinSources));
    }

    @NotNull
    public static final PsiSearchHelper.SearchCostResult isCheapEnoughToSearchConsideringOperators(@NotNull PsiSearchHelper $this$isCheapEnoughToSearchConsideringOperators, @NotNull String name2, @NotNull GlobalSearchScope scope2, @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)$this$isCheapEnoughToSearchConsideringOperators, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (OperatorConventions.isConventionName((Name)Name.identifier((String)name2))) {
            return PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = $this$isCheapEnoughToSearchConsideringOperators.isCheapEnoughToSearch(name2, scope2, fileToIgnoreOccurrencesIn, progress);
        Intrinsics.checkNotNullExpressionValue((Object)searchCostResult, (String)"isCheapEnoughToSearch(na\u2026eOccurrencesIn, progress)");
        return searchCostResult;
    }

    public static final boolean findScriptsWithUsages(@NotNull KtNamedDeclaration declaration2, @NotNull Function1<? super KtFile, Boolean> processor2) {
        boolean bl;
        String string2;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Project project2 = declaration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"declaration.project");
        Project project3 = project2;
        SearchScope searchScope2 = KotlinScopeUtils.useScope((PsiElement)declaration2);
        GlobalSearchScope globalSearchScope = searchScope2 instanceof GlobalSearchScope ? (GlobalSearchScope)searchScope2 : null;
        if (globalSearchScope == null) {
            return true;
        }
        GlobalSearchScope scope2 = globalSearchScope;
        String it = string2 = declaration2.getName();
        boolean bl2 = false;
        String string3 = it;
        if (string3 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
            bl = !StringsKt.isBlank((CharSequence)it);
        } else {
            bl = false;
        }
        String string4 = bl ? string2 : null;
        if (string4 == null) {
            return true;
        }
        String name2 = string4;
        Processor collector2 = arg_0 -> SearchUtilKt.findScriptsWithUsages$lambda$5(project3, processor2, arg_0);
        return FileBasedIndex.getInstance().getFilesWithKey(IdIndex.NAME, SetsKt.setOf((Object)new IdIndexEntry(name2, true)), collector2, scope2);
    }

    public static final boolean isImportUsage(@NotNull PsiReference $this$isImportUsage) {
        Intrinsics.checkNotNullParameter((Object)$this$isImportUsage, (String)"<this>");
        PsiElement psiElement2 = $this$isImportUsage.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
        boolean $i$f$getNonStrictParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtImportDirective.class, (boolean)false) != null;
    }

    private static final boolean findScriptsWithUsages$lambda$5(Project $project, Function1 $processor, VirtualFile file2) {
        Object object;
        block3: {
            block2: {
                KtFile ktFile;
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                Intrinsics.checkNotNullParameter((Object)$processor, (String)"$processor");
                PsiFile psiFile2 = PsiManager.getInstance((Project)$project).findFile(file2);
                object = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                if (object == null) break block2;
                KtFile it = ktFile = object;
                boolean bl = false;
                object = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.scriptDefinitionExists((PsiFile)it) ? ktFile : null;
                if (object != null) break block3;
            }
            return true;
        }
        KtFile ktFile = object;
        return (Boolean)$processor.invoke((Object)ktFile);
    }
}

