/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsage;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0003\"#$B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0001J\u0006\u0010\u0011\u001a\u00020\u0000J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u001e\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\n\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "", "behaviourStack", "", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$Behaviour;", "inlineCallStack", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$InlineFunctionCall;", "(Ljava/util/List;Ljava/util/List;)V", "getBehaviourStack", "()Ljava/util/List;", "currentBehaviour", "getCurrentBehaviour", "()Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$Behaviour;", "getInlineCallStack", "component1", "component2", "copy", "dropBehaviour", "equals", "", "other", "hashCode", "", "popInlineFunctionCall", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtElement;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "toString", "", "withBehaviour", "behaviour", "withInlineFunctionCall", "callElement", "Behaviour", "Companion", "InlineFunctionCall", "kotlin.idea"})
public final class KotlinSliceAnalysisMode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Behaviour> behaviourStack;
    @NotNull
    private final List<InlineFunctionCall> inlineCallStack;
    @NotNull
    private static final KotlinSliceAnalysisMode Default = new KotlinSliceAnalysisMode(CollectionsKt.emptyList(), CollectionsKt.emptyList());

    public KotlinSliceAnalysisMode(@NotNull List<? extends Behaviour> behaviourStack, @NotNull List<InlineFunctionCall> inlineCallStack) {
        Intrinsics.checkNotNullParameter(behaviourStack, (String)"behaviourStack");
        Intrinsics.checkNotNullParameter(inlineCallStack, (String)"inlineCallStack");
        this.behaviourStack = behaviourStack;
        this.inlineCallStack = inlineCallStack;
    }

    @NotNull
    public final List<Behaviour> getBehaviourStack() {
        return this.behaviourStack;
    }

    @NotNull
    public final List<InlineFunctionCall> getInlineCallStack() {
        return this.inlineCallStack;
    }

    @NotNull
    public final KotlinSliceAnalysisMode withBehaviour(@NotNull Behaviour behaviour) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        return KotlinSliceAnalysisMode.copy$default(this, CollectionsKt.plus((Collection)this.behaviourStack, (Object)behaviour), null, 2, null);
    }

    @NotNull
    public final KotlinSliceAnalysisMode withInlineFunctionCall(@NotNull KtElement callElement2, @NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return KotlinSliceAnalysisMode.copy$default(this, null, CollectionsKt.plus((Collection)this.inlineCallStack, (Object)new InlineFunctionCall(callElement2, function2)), 1, null);
    }

    @NotNull
    public final KotlinSliceAnalysisMode dropBehaviour() {
        if (!(!((Collection)this.behaviourStack).isEmpty())) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        return KotlinSliceAnalysisMode.copy$default(this, CollectionsKt.dropLast(this.behaviourStack, (int)1), null, 2, null);
    }

    @NotNull
    public final Pair<KotlinSliceAnalysisMode, KtElement> popInlineFunctionCall(@NotNull KtNamedFunction function2) {
        InlineFunctionCall last2;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        InlineFunctionCall inlineFunctionCall = last2 = (InlineFunctionCall)CollectionsKt.lastOrNull(this.inlineCallStack);
        if (!Intrinsics.areEqual((Object)(inlineFunctionCall != null ? inlineFunctionCall.getFunction() : null), (Object)function2)) {
            return TuplesKt.to(null, null);
        }
        KotlinSliceAnalysisMode newMode = KotlinSliceAnalysisMode.copy$default(this, null, CollectionsKt.dropLast(this.inlineCallStack, (int)1), 1, null);
        return TuplesKt.to((Object)newMode, (Object)last2.getCallElement());
    }

    @Nullable
    public final Behaviour getCurrentBehaviour() {
        return (Behaviour)CollectionsKt.lastOrNull(this.behaviourStack);
    }

    @NotNull
    public final List<Behaviour> component1() {
        return this.behaviourStack;
    }

    @NotNull
    public final List<InlineFunctionCall> component2() {
        return this.inlineCallStack;
    }

    @NotNull
    public final KotlinSliceAnalysisMode copy(@NotNull List<? extends Behaviour> behaviourStack, @NotNull List<InlineFunctionCall> inlineCallStack) {
        Intrinsics.checkNotNullParameter(behaviourStack, (String)"behaviourStack");
        Intrinsics.checkNotNullParameter(inlineCallStack, (String)"inlineCallStack");
        return new KotlinSliceAnalysisMode(behaviourStack, inlineCallStack);
    }

    public static /* synthetic */ KotlinSliceAnalysisMode copy$default(KotlinSliceAnalysisMode kotlinSliceAnalysisMode, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            list2 = kotlinSliceAnalysisMode.behaviourStack;
        }
        if ((n & 2) != 0) {
            list3 = kotlinSliceAnalysisMode.inlineCallStack;
        }
        return kotlinSliceAnalysisMode.copy(list2, list3);
    }

    @NotNull
    public String toString() {
        return "KotlinSliceAnalysisMode(behaviourStack=" + this.behaviourStack + ", inlineCallStack=" + this.inlineCallStack + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.behaviourStack).hashCode();
        result2 = result2 * 31 + ((Object)this.inlineCallStack).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (!(other2 instanceof KotlinSliceAnalysisMode)) {
            return false;
        }
        KotlinSliceAnalysisMode kotlinSliceAnalysisMode = (KotlinSliceAnalysisMode)other2;
        if (!Intrinsics.areEqual(this.behaviourStack, kotlinSliceAnalysisMode.behaviourStack)) {
            return false;
        }
        return Intrinsics.areEqual(this.inlineCallStack, kotlinSliceAnalysisMode.inlineCallStack);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00a6\u0002J\b\u0010\u000b\u001a\u00020\fH&J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$Behaviour;", "", "slicePresentationPrefix", "", "getSlicePresentationPrefix", "()Ljava/lang/String;", "testPresentationPrefix", "getTestPresentationPrefix", "equals", "", "other", "hashCode", "", "processUsages", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "parent", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceUsage;", "uniqueProcessor", "Lcom/intellij/util/Processor;", "Lcom/intellij/slicer/SliceUsage;", "kotlin.idea"})
    public static interface Behaviour {
        public void processUsages(@NotNull KtElement var1, @NotNull KotlinSliceUsage var2, @NotNull Processor<? super SliceUsage> var3);

        @NotNull
        public String getSlicePresentationPrefix();

        @NotNull
        public String getTestPresentationPrefix();

        public boolean equals(@Nullable Object var1);

        public int hashCode();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$Companion;", "", "()V", "Default", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "getDefault", "()Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "kotlin.idea"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinSliceAnalysisMode getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode$InlineFunctionCall;", "", "callElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/psi/KtNamedFunction;)V", "getCallElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "callElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFunction", "()Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "functionPointer", "equals", "", "other", "hashCode", "", "kotlin.idea"})
    public static final class InlineFunctionCall {
        @NotNull
        private final SmartPsiElementPointer<KtElement> callElementPointer;
        @NotNull
        private final SmartPsiElementPointer<KtNamedFunction> functionPointer;

        public InlineFunctionCall(@NotNull KtElement callElement2, @NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)callElement2, (String)"callElement");
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            this.callElementPointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)callElement2));
            this.functionPointer = PsiUtilsKt.createSmartPointer((PsiElement)((PsiElement)function2));
        }

        @Nullable
        public final KtElement getCallElement() {
            return (KtElement)this.callElementPointer.getElement();
        }

        @Nullable
        public final KtNamedFunction getFunction() {
            return (KtNamedFunction)this.functionPointer.getElement();
        }

        public boolean equals(@Nullable Object other2) {
            if (this == other2) {
                return true;
            }
            return other2 instanceof InlineFunctionCall && Intrinsics.areEqual((Object)((InlineFunctionCall)other2).getCallElement(), (Object)this.getCallElement()) && Intrinsics.areEqual((Object)((InlineFunctionCall)other2).getFunction(), (Object)this.getFunction());
        }

        public int hashCode() {
            return 0;
        }
    }
}

