/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePlugin;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.facet.KotlinFacet;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinFacetType;
import org.jetbrains.kotlin.idea.statistics.KotlinASStatisticsEventFlags;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getBuildSystemType", "", "it", "Lcom/intellij/openapi/module/Module;", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "kotlin.project-configuration"})
@SourceDebugExtension(value={"SMAP\nProjectConfigurationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1855#2,2:92\n*S KotlinDebug\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector\n*L\n31#1:92,2\n*E\n"})
public final class ProjectConfigurationCollector
extends ProjectUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("kotlin.project.configuration", 10, null, 4, null);
    @NotNull
    private static final StringEventField systemField;
    @NotNull
    private static final StringEventField platformField;
    @NotNull
    private static final StringEventField languageLevelField;
    @NotNull
    private static final BooleanEventField isMPPBuild;
    @NotNull
    private static final PrimitiveEventField<PluginInfo> pluginInfoField;
    @NotNull
    private static final LongEventField eventFlags;
    @NotNull
    private static final VarargEventId buildEvent;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Set metrics = new LinkedHashSet();
        List list2 = ProjectFacetManager.getInstance((Project)project2).getModulesWithFacet(KotlinFacetType.Companion.getTYPE_ID());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance(project).get\u2026(KotlinFacetType.TYPE_ID)");
        List modulesWithFacet = list2;
        if (!((Collection)modulesWithFacet).isEmpty()) {
            Iterable $this$forEach$iv = modulesWithFacet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Module it = (Module)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String buildSystem = this.getBuildSystemType(it);
                String platform2 = ConfigureKotlinInProjectUtilsKt.getPlatform(it);
                Object object = KotlinFacet.Companion.get(it);
                String languageLevel = object != null && (object = (KotlinFacetConfiguration)object.getConfiguration()) != null && (object = object.getSettings()) != null && (object = object.getLanguageLevel()) != null ? object.getVersionString() : null;
                EventPair[] eventPairArray = new EventPair[]{systemField.with((Object)buildSystem), platformField.with((Object)platform2), languageLevelField.with((Object)languageLevel), isMPPBuild.with((Object)(KotlinFacetUtils.isMultiPlatformModule(it) || KotlinFacetUtils.isNewMultiPlatformModule(it) ? 1 : 0)), pluginInfoField.with((Object)KotlinIdePlugin.INSTANCE.getPluginInfo()), eventFlags.with((Object)KotlinASStatisticsEventFlags.INSTANCE.calculateAndPackEventsFlagsToLong(it))};
                metrics.add(buildEvent.metric(eventPairArray));
            }
        }
        return metrics;
    }

    private final String getBuildSystemType(Module it) {
        String string2;
        BuildSystemType buildSystem = BuildSystemTypeKt.getBuildSystemType(it);
        if (buildSystem == BuildSystemType.JPS) {
            string2 = "JPS";
        } else {
            String string3 = buildSystem.toString().toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"maven", (boolean)false, (int)2, null)) {
                string2 = "Maven";
            } else {
                String string4 = buildSystem.toString().toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                string2 = StringsKt.contains$default((CharSequence)string4, (CharSequence)"gradle", (boolean)false, (int)2, null) ? "Gradle" : "unknown";
            }
        }
        return string2;
    }

    static {
        Object[] objectArray = new String[]{"JPS", "Maven", "Gradle", "unknown"};
        systemField = EventFields.String((String)"system", (List)CollectionsKt.listOf((Object[])objectArray));
        platformField = EventFields.String((String)"platform", (List)ProjectConfigurationCollector.Companion.composePlatformFields());
        languageLevelField = EventFields.StringValidatedByRegexp((String)"languageLevel", (String)"version");
        isMPPBuild = EventFields.Boolean((String)"isMPP");
        pluginInfoField = EventFields.PluginInfo;
        eventFlags = EventFields.Long((String)"eventFlags");
        objectArray = new EventField[]{systemField, platformField, isMPPBuild, languageLevelField, pluginInfoField, eventFlags};
        buildEvent = GROUP.registerVarargEvent("Build", (EventField[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "buildEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "eventFlags", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "isMPPBuild", "Lcom/intellij/internal/statistic/eventLog/events/BooleanEventField;", "languageLevelField", "Lcom/intellij/internal/statistic/eventLog/events/StringEventField;", "platformField", "pluginInfoField", "Lcom/intellij/internal/statistic/eventLog/events/PrimitiveEventField;", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "systemField", "composePlatformFields", "", "", "kotlin.project-configuration"})
    @SourceDebugExtension(value={"SMAP\nProjectConfigurationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1549#2:92\n1620#2,3:93\n*S KotlinDebug\n*F\n+ 1 ProjectConfigurationCollector.kt\norg/jetbrains/kotlin/idea/statistics/ProjectConfigurationCollector$Companion\n*L\n75#1:92\n75#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<String> composePlatformFields() {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = new List[2];
            Object object = new String[]{"jvm", "jvm.android", "js", "wasm", "common", "native.unknown", "unknown"};
            objectArray[0] = CollectionsKt.listOf((Object[])object);
            object = KonanTarget.Companion.getPredefinedTargets().keySet();
            int n = 1;
            Object[] objectArray2 = objectArray;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((CallSite)((Object)("native." + (String)it)));
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            return CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])objectArray));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

