/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.google.common.base.MoreObjects;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

class BufferingFileWrapper
implements IAbstractFile {
    private final File myFile;

    public BufferingFileWrapper(@NotNull File file) {
        if (file == null) {
            BufferingFileWrapper.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    public InputStream getContents() throws StreamException {
        try {
            byte[] content = this.readFile();
            return new ByteArrayInputStream(content);
        }
        catch (IOException e) {
            throw new StreamException((Exception)e, (IAbstractFile)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile() throws IOException {
        try (DataInputStream is = new DataInputStream(new FileInputStream(this.myFile));){
            byte[] data = new byte[(int)this.myFile.length()];
            is.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            BufferingFileWrapper.$$$reportNull$$$0(1);
        }
        return file;
    }

    public void setContents(InputStream source) throws StreamException {
        throw new UnsupportedOperationException();
    }

    public OutputStream getOutputStream() throws StreamException {
        throw new UnsupportedOperationException();
    }

    public String getOsLocation() {
        return this.myFile.getAbsolutePath();
    }

    public boolean exists() {
        return this.myFile.isFile();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("file", (Object)this.myFile).toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/layoutlib/BufferingFileWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/layoutlib/BufferingFileWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

