/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.ide.common.rendering.api.Bridge;
import com.android.io.IAbstractFile;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.tools.idea.layoutlib.BufferingFileWrapper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLogWrapper;
import com.android.tools.idea.layoutlib.LayoutlibBundle;
import com.android.tools.idea.layoutlib.LogWrapper;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.utils.ILogger;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class LayoutLibraryLoader {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.LayoutLibraryLoader");
    private static final Map<IAndroidTarget, LayoutLibrary> ourLibraryCache = ContainerUtil.createWeakKeySoftValueMap();

    private LayoutLibraryLoader() {
    }

    @NotNull
    private static LayoutLibrary loadImpl(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        Path fontFolderPath;
        if (target == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(0);
        }
        if (enumMap == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(1);
        }
        if (!Files.exists(fontFolderPath = target.getPath(12), new LinkOption[0]) || !Files.isDirectory(fontFolderPath, new LinkOption[0])) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", fontFolderPath), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", FileUtilRt.toSystemDependentName((String)platformFolderPath)), new Throwable[0]);
        }
        File buildProp = new File(platformFolder, "build.prop");
        if (!buildProp.isFile()) {
            throw new RenderingException(LayoutlibBundle.message("android.file.not.exist.error", FileUtilRt.toSystemDependentName((String)buildProp.getPath())), new Throwable[0]);
        }
        LogWrapper logger = new LogWrapper(LOG);
        Map<String, String> buildPropMap = ProjectProperties.parsePropertyFile((IAbstractFile)new BufferingFileWrapper(buildProp), (ILogger)logger);
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        String dataPath = FileUtil.toSystemIndependentName((String)target.getPath(7).toString());
        String[] keyboardPaths = new String[]{dataPath + "/keyboards/Generic.kcm"};
        LayoutLibrary library = (LayoutLibrary)LayoutLibraryProvider.EP_NAME.computeSafeIfAny(LayoutLibraryProvider::getLibrary);
        if (library == null || !library.init(buildPropMap != null ? buildPropMap : Collections.emptyMap(), fontFolderPath.toFile(), LayoutLibraryLoader.getNativeLibraryPath(dataPath), dataPath + "/icu/icudt70l.dat", keyboardPaths, enumMap, layoutLog)) {
            throw new RenderingException(LayoutlibBundle.message("layoutlib.init.failed", new Object[0]), new Throwable[0]);
        }
        LayoutLibrary layoutLibrary = library;
        if (layoutLibrary == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(2);
        }
        return layoutLibrary;
    }

    @NotNull
    private static String getNativeLibraryPath(@NotNull String dataPath) {
        if (dataPath == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(3);
        }
        String string = dataPath + "/" + LayoutLibraryLoader.getPlatformName() + "/lib64/";
        if (string == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return CpuArch.isArm64() ? "mac-arm" : "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }

    @NotNull
    public static synchronized LayoutLibrary load(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap, @NotNull Supplier<Boolean> hasExternalCrash) throws RenderingException {
        if (target == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(5);
        }
        if (enumMap == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(6);
        }
        if (hasExternalCrash == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(7);
        }
        if (Bridge.hasNativeCrash()) {
            throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
        }
        LayoutLibrary library = ourLibraryCache.get(target);
        if (library == null || library.isDisposed()) {
            if (hasExternalCrash.get().booleanValue()) {
                Bridge.setNativeCrash((boolean)true);
                throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
            }
            library = LayoutLibraryLoader.loadImpl(target, enumMap);
            ourLibraryCache.put(target, library);
        }
        LayoutLibrary layoutLibrary = library;
        if (layoutLibrary == null) {
            LayoutLibraryLoader.$$$reportNull$$$0(8);
        }
        return layoutLibrary;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumMap";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/layoutlib/LayoutLibraryLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasExternalCrash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/layoutlib/LayoutLibraryLoader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeLibraryPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadImpl";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNativeLibraryPath";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8 -> new IllegalStateException(string);
        };
    }

    public static abstract class LayoutLibraryProvider {
        public static final ExtensionPointName<LayoutLibraryProvider> EP_NAME = new ExtensionPointName("com.android.tools.idea.layoutlib.layoutLibraryProvider");

        @NotNull
        public abstract LayoutLibrary getLibrary();

        @NotNull
        public abstract Class<?> getFrameworkRClass();
    }
}

