/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ManifestMergeFailureParser
implements PatternAwareOutputParser {
    private static final Pattern ERROR1 = Pattern.compile("\\[([^:].[^:]+):(\\d+)\\] (.+)");
    private static final Pattern ERROR2 = Pattern.compile("([^:].[^:]+):(\\d+):(\\d+) (.+):");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        Matcher m;
        if (line == null) {
            ManifestMergeFailureParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            ManifestMergeFailureParser.$$$reportNull$$$0(1);
        }
        if (messages == null) {
            ManifestMergeFailureParser.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            ManifestMergeFailureParser.$$$reportNull$$$0(3);
        }
        if ((m = ERROR1.matcher(line)).matches()) {
            int lineNumber;
            String sourcePath = m.group(1);
            try {
                lineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            String message = m.group(3);
            messages.add(new Message(Message.Kind.ERROR, message, new SourceFilePosition(new File(sourcePath), new SourcePosition(lineNumber - 1, -1, -1)), new SourceFilePosition[0]));
            return true;
        }
        m = ERROR2.matcher(line);
        if (m.matches()) {
            int column;
            int lineNumber;
            String sourcePath = ManifestMergeFailureParser.removeLeadingTab(m.group(1)).trim();
            try {
                lineNumber = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            try {
                column = Integer.parseInt(m.group(3));
            }
            catch (NumberFormatException e) {
                throw new ParsingFailedException((Throwable)e);
            }
            if (lineNumber == 0 && column == 0) {
                String next = reader.peek(0);
                if (next != null && next.contains("Validation failed, exiting")) {
                    reader.readLine();
                    return true;
                }
            } else {
                String msg = reader.readLine();
                if (msg != null) {
                    msg = ManifestMergeFailureParser.removeLeadingTab(msg).trim();
                    Message.Kind kind = Message.Kind.findIgnoringCase((String)m.group(4), (Message.Kind)Message.Kind.ERROR);
                    messages.add(new Message(kind, msg.trim(), new SourceFilePosition(new File(sourcePath), new SourcePosition(lineNumber - 1, column - 1, -1)), new SourceFilePosition[0]));
                    return true;
                }
            }
        }
        return false;
    }

    @NotNull
    private static String removeLeadingTab(@NotNull String s) {
        if (s == null) {
            ManifestMergeFailureParser.$$$reportNull$$$0(4);
        }
        if (s.startsWith("\t") && s.length() > 1) {
            String string = s.substring(1);
            if (string == null) {
                ManifestMergeFailureParser.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            ManifestMergeFailureParser.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/output/parser/androidPlugin/ManifestMergeFailureParser";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLeadingTab";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeLeadingTab";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

