/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Strings;
import com.google.common.io.Closeables;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidGradleSettings {
    private static final Logger LOG = Logger.getInstance(AndroidGradleSettings.class);
    @NonNls
    private static final String JVM_ARG_FORMAT = "-D%1$s=%2$s";
    @NonNls
    private static final String PROJECT_PROPERTY_FORMAT = "-P%1$s=%2$s";
    @NonNls
    public static final String ANDROID_HOME_JVM_ARG = "android.home";

    private AndroidGradleSettings() {
    }

    public static boolean isAndroidSdkDirInLocalPropertiesFile(@NotNull File projectDir) {
        String androidHome;
        if (projectDir == null) {
            AndroidGradleSettings.$$$reportNull$$$0(0);
        }
        if (!Strings.isNullOrEmpty((String)(androidHome = AndroidGradleSettings.getAndroidHomeFromLocalPropertiesFile(projectDir)))) {
            String msg = String.format("Found Android SDK home at '%1$s' (from local.properties file)", androidHome);
            LOG.info(msg);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getAndroidHomeFromLocalPropertiesFile(@NotNull File projectDir) {
        File filePath;
        if (projectDir == null) {
            AndroidGradleSettings.$$$reportNull$$$0(1);
        }
        if (!(filePath = new File(projectDir, "local.properties")).isFile()) {
            return null;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String msg = String.format("Failed to read file '%1$s'", filePath.getPath());
            LOG.error(msg, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                Closeables.close((Closeable)fileInputStream, (boolean)true);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
        return properties.getProperty("sdk.dir");
    }

    @NotNull
    public static String createAndroidHomeJvmArg(@NotNull String androidHome) {
        if (androidHome == null) {
            AndroidGradleSettings.$$$reportNull$$$0(2);
        }
        return AndroidGradleSettings.createJvmArg(ANDROID_HOME_JVM_ARG, androidHome);
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, int value) {
        if (name == null) {
            AndroidGradleSettings.$$$reportNull$$$0(3);
        }
        return AndroidGradleSettings.createJvmArg(name, String.valueOf(value));
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, boolean value) {
        if (name == null) {
            AndroidGradleSettings.$$$reportNull$$$0(4);
        }
        return AndroidGradleSettings.createJvmArg(name, String.valueOf(value));
    }

    @NotNull
    public static String createJvmArg(@NotNull String name, @NotNull String value) {
        if (name == null) {
            AndroidGradleSettings.$$$reportNull$$$0(5);
        }
        if (value == null) {
            AndroidGradleSettings.$$$reportNull$$$0(6);
        }
        String string = String.format(JVM_ARG_FORMAT, name, value);
        if (string == null) {
            AndroidGradleSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String createProjectProperty(@NotNull String name, boolean value) {
        if (name == null) {
            AndroidGradleSettings.$$$reportNull$$$0(8);
        }
        return AndroidGradleSettings.createProjectProperty(name, String.valueOf(value));
    }

    @NotNull
    public static String createProjectProperty(@NotNull String name, int value) {
        if (name == null) {
            AndroidGradleSettings.$$$reportNull$$$0(9);
        }
        return AndroidGradleSettings.createProjectProperty(name, String.valueOf(value));
    }

    @NotNull
    public static String createProjectProperty(@NotNull String name, @NotNull String value) {
        if (name == null) {
            AndroidGradleSettings.$$$reportNull$$$0(10);
        }
        if (value == null) {
            AndroidGradleSettings.$$$reportNull$$$0(11);
        }
        String string = String.format(PROJECT_PROPERTY_FORMAT, name, value);
        if (string == null) {
            AndroidGradleSettings.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidHome";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/AndroidGradleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/AndroidGradleSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createJvmArg";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAndroidSdkDirInLocalPropertiesFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidHomeFromLocalPropertiesFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAndroidHomeJvmArg";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createJvmArg";
                break;
            }
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProjectProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 12 -> new IllegalStateException(string);
        };
    }
}

