/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.util;

import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCompilerMessageKind;
import org.jetbrains.android.util.AndroidOSProcessHandler;
import org.jetbrains.annotations.NotNull;

public final class AndroidExecutionUtil {
    private AndroidExecutionUtil() {
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> doExecute(String ... argv) throws IOException {
        return AndroidExecutionUtil.doExecute(argv, Collections.emptyMap());
    }

    @NotNull
    public static Map<AndroidCompilerMessageKind, List<String>> doExecute(String[] argv, @NotNull Map<? extends String, ? extends String> enviroment) throws IOException {
        Process process;
        AndroidBuildTestingManager testingManager;
        if (enviroment == null) {
            AndroidExecutionUtil.$$$reportNull$$$0(0);
        }
        if ((testingManager = AndroidBuildTestingManager.getTestingManager()) != null) {
            process = testingManager.getCommandExecutor().createProcess(argv, enviroment);
        } else {
            ProcessBuilder builder = new ProcessBuilder(argv);
            builder.environment().putAll(enviroment);
            process = builder.start();
        }
        ProcessResult result = AndroidExecutionUtil.readProcessOutput(process, StringUtil.join((String[])argv, (String)" "));
        Map<AndroidCompilerMessageKind, List<String>> messages = result.getMessages();
        int code = result.getExitCode();
        List<String> errMessages = messages.get((Object)AndroidCompilerMessageKind.ERROR);
        if (code != 0 && errMessages.isEmpty()) {
            throw new IOException("Command \"" + AndroidExecutionUtil.concat(argv) + "\" execution failed with exit code " + code);
        }
        if (code == 0) {
            messages.get((Object)AndroidCompilerMessageKind.WARNING).addAll(errMessages);
            errMessages.clear();
        }
        Map<AndroidCompilerMessageKind, List<String>> map = messages;
        if (map == null) {
            AndroidExecutionUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    private static String concat(String ... strs) {
        StringBuilder builder = new StringBuilder();
        int n = strs.length;
        for (int i = 0; i < n; ++i) {
            builder.append(strs[i]);
            if (i >= n - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    @NotNull
    private static ProcessResult readProcessOutput(@NotNull Process process, @NotNull String commandLine) throws IOException {
        if (process == null) {
            AndroidExecutionUtil.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            AndroidExecutionUtil.$$$reportNull$$$0(3);
        }
        AndroidOSProcessHandler handler = new AndroidOSProcessHandler(process, commandLine);
        handler.startNotify();
        handler.waitFor();
        int exitCode = handler.getProcess().exitValue();
        return new ProcessResult(handler.getInfoMessages(), handler.getErrorMessages(), exitCode);
    }

    public static <T> void addMessages(@NotNull Map<T, List<String>> messages, @NotNull Map<T, List<String>> toAdd) {
        if (messages == null) {
            AndroidExecutionUtil.$$$reportNull$$$0(4);
        }
        if (toAdd == null) {
            AndroidExecutionUtil.$$$reportNull$$$0(5);
        }
        for (Map.Entry<T, List<String>> entry : toAdd.entrySet()) {
            List<String> list = messages.get(entry.getKey());
            if (list == null) {
                list = new ArrayList<String>();
                messages.put(entry.getKey(), list);
            }
            list.addAll((Collection<String>)entry.getValue());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enviroment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/util/AndroidExecutionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/util/AndroidExecutionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doExecute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readProcessOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMessages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class ProcessResult {
        private final int myExitCode;
        private final Map<AndroidCompilerMessageKind, List<String>> myMessages;

        public ProcessResult(List<String> information, List<String> error, int exitCode) {
            this.myExitCode = exitCode;
            this.myMessages = new HashMap<AndroidCompilerMessageKind, List<String>>(2);
            this.myMessages.put(AndroidCompilerMessageKind.INFORMATION, information);
            this.myMessages.put(AndroidCompilerMessageKind.ERROR, error);
            this.myMessages.put(AndroidCompilerMessageKind.WARNING, new ArrayList());
        }

        public Map<AndroidCompilerMessageKind, List<String>> getMessages() {
            return this.myMessages;
        }

        public int getExitCode() {
            return this.myExitCode;
        }
    }
}

