/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.DependencyResolveContext;
import org.gradle.api.internal.artifacts.ResolvableDependency;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;

public class CachingDependencyResolveContext
implements DependencyResolveContext {
    private final List<Object> queue = new ArrayList<Object>();
    private final CachingDirectedGraphWalker<Object, FileCollectionInternal> walker = new CachingDirectedGraphWalker<Object, FileCollectionInternal>(new DependencyGraph());
    private final TaskDependencyFactory taskDependencyFactory;
    private final boolean transitive;
    private final Map<String, String> attributes;

    public CachingDependencyResolveContext(TaskDependencyFactory taskDependencyFactory, boolean transitive, Map<String, String> attributes) {
        this.taskDependencyFactory = taskDependencyFactory;
        this.transitive = transitive;
        this.attributes = attributes;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public FileCollection resolve() {
        try {
            this.walker.add((Iterable<Object>)this.queue);
            UnionFileCollection unionFileCollection = new UnionFileCollection(this.taskDependencyFactory, this.walker.findValues());
            return unionFileCollection;
        }
        finally {
            this.queue.clear();
        }
    }

    @Override
    public void add(Object dependency) {
        this.queue.add(dependency);
    }

    private class DependencyGraph
    implements DirectedGraph<Object, FileCollectionInternal> {
        private DependencyGraph() {
        }

        @Override
        public void getNodeValues(Object node, Collection<? super FileCollectionInternal> values, Collection<? super Object> connectedNodes) {
            if (node instanceof FileCollectionInternal) {
                FileCollectionInternal fileCollection = (FileCollectionInternal)node;
                values.add(fileCollection);
            } else if (node instanceof ResolvableDependency) {
                ResolvableDependency resolvableDependency = (ResolvableDependency)node;
                CachingDependencyResolveContext.this.queue.clear();
                resolvableDependency.resolve(CachingDependencyResolveContext.this);
                connectedNodes.addAll(CachingDependencyResolveContext.this.queue);
                CachingDependencyResolveContext.this.queue.clear();
            } else {
                throw new IllegalArgumentException(String.format("Cannot resolve object of unknown type %s.", node.getClass().getSimpleName()));
            }
        }
    }
}

