/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ivy.IvyExtraInfo;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.util.internal.CollectionUtils;

public class DefaultIvyExtraInfo
implements IvyExtraInfo {
    protected final Map<NamespaceId, String> extraInfo;

    public DefaultIvyExtraInfo() {
        this.extraInfo = new LinkedHashMap<NamespaceId, String>();
    }

    public DefaultIvyExtraInfo(Map<NamespaceId, String> extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public String get(String name) {
        ArrayList<Map.Entry<NamespaceId, String>> foundEntries = new ArrayList<Map.Entry<NamespaceId, String>>();
        for (Map.Entry<NamespaceId, String> entry : this.extraInfo.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            foundEntries.add(entry);
        }
        if (foundEntries.size() > 1) {
            String allNamespaces = Joiner.on((String)", ").join(CollectionUtils.collect(foundEntries, original -> ((NamespaceId)original.getKey()).getNamespace()));
            throw new InvalidUserDataException(String.format("Cannot get extra info element named '%s' by name since elements with this name were found from multiple namespaces (%s).  Use get(String namespace, String name) instead.", name, allNamespaces));
        }
        return foundEntries.size() == 0 ? null : (String)((Map.Entry)foundEntries.get(0)).getValue();
    }

    @Override
    public String get(String namespace, String name) {
        return this.extraInfo.get(new NamespaceId(namespace, name));
    }

    @Override
    public Map<QName, String> asMap() {
        LinkedHashMap<QName, String> map = new LinkedHashMap<QName, String>();
        for (Map.Entry<NamespaceId, String> entry : this.extraInfo.entrySet()) {
            map.put(new QName(entry.getKey().getNamespace(), entry.getKey().getName()), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }
}

