/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DefaultExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.component.external.model.DefaultImmutableCapability;
import org.gradle.internal.component.external.model.MutableComponentVariant;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ShadowedImmutableCapability;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.gson.stream.JsonReader;
import org.gradle.internal.impldep.com.google.gson.stream.JsonToken;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.snapshot.impl.CoercingStringValueSnapshot;

public class GradleModuleMetadataParser {
    private static final Logger LOGGER = Logging.getLogger(GradleModuleMetadataParser.class);
    public static final String FORMAT_VERSION = "1.1";
    private final ImmutableAttributesFactory attributesFactory;
    private final NamedObjectInstantiator instantiator;
    private final ExcludeRuleConverter excludeRuleConverter;

    public GradleModuleMetadataParser(ImmutableAttributesFactory attributesFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, NamedObjectInstantiator instantiator2) {
        this.attributesFactory = attributesFactory;
        this.instantiator = instantiator2;
        this.excludeRuleConverter = new DefaultExcludeRuleConverter(moduleIdentifierFactory);
    }

    public ImmutableAttributesFactory getAttributesFactory() {
        return this.attributesFactory;
    }

    public NamedObjectInstantiator getInstantiator() {
        return this.instantiator;
    }

    public void parse(LocallyAvailableExternalResource resource, MutableModuleComponentResolveMetadata metadata) {
        resource.withContent(inputStream -> {
            String version = null;
            try {
                JsonReader reader2 = new JsonReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                reader2.beginObject();
                if (reader2.peek() != JsonToken.NAME) {
                    throw new RuntimeException("Module metadata should contain a 'formatVersion' value.");
                }
                String name = reader2.nextName();
                if (!name.equals("formatVersion")) {
                    throw new RuntimeException(String.format("The 'formatVersion' value should be the first value in a module metadata. Found '%s' instead.", name));
                }
                if (reader2.peek() != JsonToken.STRING) {
                    throw new RuntimeException("The 'formatVersion' value should have a string value.");
                }
                version = reader2.nextString();
                this.consumeTopLevelElements(reader2, metadata);
                File file = resource.getFile();
                if (!FORMAT_VERSION.equals(version)) {
                    LOGGER.debug("Unrecognized metadata format version '{}' found in '{}'. Parsing succeeded but it may lead to unexpected resolution results. Try upgrading to a newer version of Gradle", version, file);
                }
                return null;
            }
            catch (Exception e) {
                if (version != null && !FORMAT_VERSION.equals(version)) {
                    throw new MetaDataParseException("module metadata", resource, String.format("unsupported format version '%s' specified in module metadata. This version of Gradle supports format version %s.", version, FORMAT_VERSION), e);
                }
                throw new MetaDataParseException("module metadata", resource, e);
            }
        });
        this.maybeAddEnforcedPlatformVariant(metadata);
    }

    private void maybeAddEnforcedPlatformVariant(MutableModuleComponentResolveMetadata metadata) {
        List<? extends MutableComponentVariant> variants = metadata.getMutableVariants();
        if (variants == null || variants.isEmpty()) {
            return;
        }
        for (MutableComponentVariant variant : ImmutableList.copyOf(variants)) {
            AttributeValue<String> entry = variant.getAttributes().findEntry(MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE);
            if (!entry.isPresent() || !"platform".equals(entry.get()) || !variant.getCapabilities().isEmpty()) continue;
            ImmutableAttributes enforcedAttributes = this.attributesFactory.concat(variant.getAttributes(), MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE, new CoercingStringValueSnapshot("enforced-platform", this.instantiator));
            Capability enforcedCapability = this.buildShadowPlatformCapability(metadata.getId());
            metadata.addVariant(variant.copy("enforced" + StringUtils.capitalize((String)variant.getName()), enforcedAttributes, enforcedCapability));
        }
    }

    private Capability buildShadowPlatformCapability(ModuleComponentIdentifier componentId) {
        return new ShadowedImmutableCapability(new DefaultImmutableCapability(componentId.getGroup(), componentId.getModule(), componentId.getVersion()), "-derived-enforced-platform");
    }

    private void consumeTopLevelElements(JsonReader reader2, MutableModuleComponentResolveMetadata metadata) throws IOException {
        block8: while (reader2.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader2.nextName()) {
                case "variants": {
                    this.consumeVariants(reader2, metadata);
                    continue block8;
                }
                case "component": {
                    this.consumeComponent(reader2, metadata);
                    continue block8;
                }
            }
            this.consumeAny(reader2);
        }
    }

    private void consumeComponent(JsonReader reader2, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader2.beginObject();
        block6: while (reader2.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader2.nextName()) {
                case "attributes": {
                    metadata.setAttributes(this.consumeAttributes(reader2));
                    continue block6;
                }
            }
            this.consumeAny(reader2);
        }
        reader2.endObject();
    }

    private void consumeVariants(JsonReader reader2, MutableModuleComponentResolveMetadata metadata) throws IOException {
        reader2.beginArray();
        while (reader2.peek() != JsonToken.END_ARRAY) {
            this.consumeVariant(reader2, metadata);
        }
        reader2.endArray();
    }

    private void consumeVariant(JsonReader reader2, MutableModuleComponentResolveMetadata metadata) throws IOException {
        String variantName = null;
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        List<Object> files = Collections.emptyList();
        List<ModuleDependency> dependencies = Collections.emptyList();
        List<Object> dependencyConstraints = Collections.emptyList();
        List<VariantCapability> capabilities = Collections.emptyList();
        boolean availableExternally = false;
        reader2.beginObject();
        block18: while (reader2.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader2.nextName()) {
                case "name": {
                    variantName = reader2.nextString();
                    continue block18;
                }
                case "attributes": {
                    attributes = this.consumeAttributes(reader2);
                    continue block18;
                }
                case "files": {
                    files = this.consumeFiles(reader2);
                    continue block18;
                }
                case "dependencies": {
                    dependencies = this.consumeDependencies(reader2);
                    continue block18;
                }
                case "dependencyConstraints": {
                    dependencyConstraints = this.consumeDependencyConstraints(reader2);
                    continue block18;
                }
                case "capabilities": {
                    capabilities = this.consumeCapabilities(reader2, true);
                    continue block18;
                }
                case "available-at": {
                    availableExternally = true;
                    dependencies = this.consumeVariantLocation(reader2);
                    continue block18;
                }
            }
            this.consumeAny(reader2);
        }
        this.assertDefined(reader2, "name", variantName);
        reader2.endObject();
        MutableComponentVariant variant = metadata.addVariant(variantName, attributes);
        variant.setAvailableExternally(availableExternally);
        if (availableExternally) {
            if (!dependencyConstraints.isEmpty()) {
                throw new RuntimeException("A variant declared with available-at cannot declare dependency constraints");
            }
            if (!files.isEmpty()) {
                throw new RuntimeException("A variant declared with available-at cannot declare files");
            }
        }
        this.populateVariant(files, dependencies, dependencyConstraints, capabilities, variant);
    }

    private void populateVariant(List<ModuleFile> files, List<ModuleDependency> dependencies, List<ModuleDependencyConstraint> dependencyConstraints, List<VariantCapability> capabilities, MutableComponentVariant variant) {
        for (ModuleFile file : files) {
            variant.addFile(file.name, file.uri);
        }
        for (ModuleDependency dependency : dependencies) {
            variant.addDependency(dependency.group, dependency.module, dependency.versionConstraint, (List<ExcludeMetadata>)dependency.excludes, dependency.reason, dependency.attributes, dependency.requestedCapabilities, dependency.endorsing, dependency.artifact);
        }
        for (ModuleDependencyConstraint dependencyConstraint : dependencyConstraints) {
            variant.addDependencyConstraint(dependencyConstraint.group, dependencyConstraint.module, dependencyConstraint.versionConstraint, dependencyConstraint.reason, dependencyConstraint.attributes);
        }
        for (VariantCapability capability : capabilities) {
            variant.addCapability(capability.group, capability.name, capability.version);
        }
    }

    private List<ModuleDependency> consumeVariantLocation(JsonReader reader2) throws IOException {
        String url = null;
        String group = null;
        String module = null;
        String version = null;
        reader2.beginObject();
        block12: while (reader2.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader2.nextName()) {
                case "url": {
                    url = reader2.nextString();
                    continue block12;
                }
                case "group": {
                    group = reader2.nextString();
                    continue block12;
                }
                case "module": {
                    module = reader2.nextString();
                    continue block12;
                }
                case "version": {
                    version = reader2.nextString();
                    continue block12;
                }
            }
            this.consumeAny(reader2);
        }
        this.assertDefined(reader2, "url", url);
        this.assertDefined(reader2, "group", group);
        this.assertDefined(reader2, "module", module);
        this.assertDefined(reader2, "version", version);
        reader2.endObject();
        return ImmutableList.of((Object)new ModuleDependency(group, module, new DefaultImmutableVersionConstraint(version), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), null, ImmutableAttributes.EMPTY, Collections.emptyList(), false, null));
    }

    private List<ModuleDependency> consumeDependencies(JsonReader reader2) throws IOException {
        LinkedHashSet<ModuleDependency> dependencies = new LinkedHashSet<ModuleDependency>();
        reader2.beginArray();
        while (reader2.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String module = null;
            String reason = null;
            ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
            ImmutableVersionConstraint version = DefaultImmutableVersionConstraint.of();
            ImmutableList<ExcludeMetadata> excludes = ImmutableList.of();
            Object requestedCapabilities = ImmutableList.of();
            IvyArtifactName artifactSelector = null;
            boolean endorseStrictVersions = false;
            reader2.beginObject();
            block23: while (reader2.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader2.nextName()) {
                    case "group": {
                        group = reader2.nextString();
                        continue block23;
                    }
                    case "module": {
                        module = reader2.nextString();
                        continue block23;
                    }
                    case "version": {
                        version = this.consumeVersion(reader2);
                        continue block23;
                    }
                    case "excludes": {
                        excludes = this.consumeExcludes(reader2);
                        continue block23;
                    }
                    case "reason": {
                        reason = reader2.nextString();
                        continue block23;
                    }
                    case "attributes": {
                        attributes = this.consumeAttributes(reader2);
                        continue block23;
                    }
                    case "requestedCapabilities": {
                        requestedCapabilities = this.consumeCapabilities(reader2, false);
                        continue block23;
                    }
                    case "endorseStrictVersions": {
                        endorseStrictVersions = reader2.nextBoolean();
                        continue block23;
                    }
                    case "thirdPartyCompatibility": {
                        reader2.beginObject();
                        while (reader2.peek() != JsonToken.END_OBJECT) {
                            String compatibilityFeatureName = reader2.nextName();
                            if (compatibilityFeatureName.equals("artifactSelector")) {
                                artifactSelector = this.consumeArtifactSelector(reader2);
                                continue;
                            }
                            this.consumeAny(reader2);
                        }
                        reader2.endObject();
                        continue block23;
                    }
                }
                this.consumeAny(reader2);
            }
            this.assertDefined(reader2, "group", group);
            this.assertDefined(reader2, "module", module);
            reader2.endObject();
            dependencies.add(new ModuleDependency(group, module, version, excludes, reason, attributes, (List<? extends Capability>)requestedCapabilities, endorseStrictVersions, artifactSelector));
        }
        reader2.endArray();
        return new ArrayList<ModuleDependency>(dependencies);
    }

    private IvyArtifactName consumeArtifactSelector(JsonReader reader2) throws IOException {
        reader2.beginObject();
        String artifactName = null;
        String type = null;
        String extension = null;
        String classifier = null;
        block12: while (reader2.peek() != JsonToken.END_OBJECT) {
            String name;
            switch (name = reader2.nextName()) {
                case "name": {
                    artifactName = reader2.nextString();
                    continue block12;
                }
                case "type": {
                    type = reader2.nextString();
                    continue block12;
                }
                case "extension": {
                    extension = reader2.nextString();
                    continue block12;
                }
                case "classifier": {
                    classifier = reader2.nextString();
                    continue block12;
                }
            }
            this.consumeAny(reader2);
        }
        this.assertDefined(reader2, "name", artifactName);
        this.assertDefined(reader2, "type", type);
        reader2.endObject();
        return new DefaultIvyArtifactName(artifactName, type, extension, classifier);
    }

    private List<VariantCapability> consumeCapabilities(JsonReader reader2, boolean versionRequired) throws IOException {
        ImmutableList.Builder capabilities = ImmutableList.builder();
        reader2.beginArray();
        while (reader2.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String name = null;
            String version = null;
            reader2.beginObject();
            while (reader2.peek() != JsonToken.END_OBJECT) {
                String val;
                switch (val = reader2.nextName()) {
                    case "group": {
                        group = reader2.nextString();
                        break;
                    }
                    case "name": {
                        name = reader2.nextString();
                        break;
                    }
                    case "version": {
                        if (reader2.peek() == JsonToken.NULL) {
                            reader2.nextNull();
                            break;
                        }
                        version = reader2.nextString();
                    }
                }
            }
            this.assertDefined(reader2, "group", group);
            this.assertDefined(reader2, "name", name);
            if (versionRequired) {
                this.assertDefined(reader2, "version", version);
            }
            reader2.endObject();
            capabilities.add((Object)new VariantCapability(group, name, version));
        }
        reader2.endArray();
        return capabilities.build();
    }

    private List<ModuleDependencyConstraint> consumeDependencyConstraints(JsonReader reader2) throws IOException {
        LinkedHashSet<ModuleDependencyConstraint> dependencies = new LinkedHashSet<ModuleDependencyConstraint>();
        reader2.beginArray();
        while (reader2.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String module = null;
            String reason = null;
            ImmutableVersionConstraint version = DefaultImmutableVersionConstraint.of();
            ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
            reader2.beginObject();
            block15: while (reader2.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader2.nextName()) {
                    case "group": {
                        group = reader2.nextString();
                        continue block15;
                    }
                    case "module": {
                        module = reader2.nextString();
                        continue block15;
                    }
                    case "version": {
                        version = this.consumeVersion(reader2);
                        continue block15;
                    }
                    case "reason": {
                        reason = reader2.nextString();
                        continue block15;
                    }
                    case "attributes": {
                        attributes = this.consumeAttributes(reader2);
                        continue block15;
                    }
                }
                this.consumeAny(reader2);
            }
            this.assertDefined(reader2, "group", group);
            this.assertDefined(reader2, "module", module);
            reader2.endObject();
            dependencies.add(new ModuleDependencyConstraint(group, module, version, reason, attributes));
        }
        reader2.endArray();
        return new ArrayList<ModuleDependencyConstraint>(dependencies);
    }

    private ImmutableVersionConstraint consumeVersion(JsonReader reader2) throws IOException {
        String requiredVersion = "";
        String preferredVersion = "";
        String strictVersion = "";
        ArrayList rejects = Lists.newArrayList();
        reader2.beginObject();
        block12: while (reader2.peek() != JsonToken.END_OBJECT) {
            String cst;
            switch (cst = reader2.nextName()) {
                case "prefers": {
                    preferredVersion = reader2.nextString();
                    continue block12;
                }
                case "requires": {
                    requiredVersion = reader2.nextString();
                    continue block12;
                }
                case "strictly": {
                    strictVersion = reader2.nextString();
                    continue block12;
                }
                case "rejects": {
                    reader2.beginArray();
                    while (reader2.peek() != JsonToken.END_ARRAY) {
                        rejects.add(reader2.nextString());
                    }
                    reader2.endArray();
                    continue block12;
                }
            }
            this.consumeAny(reader2);
        }
        reader2.endObject();
        return DefaultImmutableVersionConstraint.of(preferredVersion, requiredVersion, strictVersion, rejects);
    }

    private ImmutableList<ExcludeMetadata> consumeExcludes(JsonReader reader2) throws IOException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        reader2.beginArray();
        while (reader2.peek() != JsonToken.END_ARRAY) {
            String group = null;
            String module = null;
            reader2.beginObject();
            block9: while (reader2.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader2.nextName()) {
                    case "group": {
                        group = reader2.nextString();
                        continue block9;
                    }
                    case "module": {
                        module = reader2.nextString();
                        continue block9;
                    }
                }
                this.consumeAny(reader2);
            }
            reader2.endObject();
            ExcludeMetadata exclude = this.excludeRuleConverter.createExcludeRule(group, module);
            builder.add((Object)exclude);
        }
        reader2.endArray();
        return builder.build();
    }

    private List<ModuleFile> consumeFiles(JsonReader reader2) throws IOException {
        ArrayList<ModuleFile> files = new ArrayList<ModuleFile>();
        reader2.beginArray();
        while (reader2.peek() != JsonToken.END_ARRAY) {
            String fileName = null;
            String fileUrl = null;
            reader2.beginObject();
            block9: while (reader2.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader2.nextName()) {
                    case "name": {
                        fileName = reader2.nextString();
                        continue block9;
                    }
                    case "url": {
                        fileUrl = reader2.nextString();
                        continue block9;
                    }
                }
                this.consumeAny(reader2);
            }
            this.assertDefined(reader2, "name", fileName);
            this.assertDefined(reader2, "url", fileUrl);
            reader2.endObject();
            files.add(new ModuleFile(fileName, fileUrl));
        }
        reader2.endArray();
        return files;
    }

    private ImmutableAttributes consumeAttributes(JsonReader reader2) throws IOException {
        ImmutableAttributes attributes = ImmutableAttributes.EMPTY;
        reader2.beginObject();
        while (reader2.peek() != JsonToken.END_OBJECT) {
            String attrName = reader2.nextName();
            if (reader2.peek() == JsonToken.BOOLEAN) {
                boolean attrValue = reader2.nextBoolean();
                attributes = this.attributesFactory.concat(attributes, Attribute.of(attrName, Boolean.class), attrValue);
                continue;
            }
            if (reader2.peek() == JsonToken.NUMBER) {
                Integer attrValue = reader2.nextInt();
                attributes = this.attributesFactory.concat(attributes, Attribute.of(attrName, Integer.class), attrValue);
                continue;
            }
            String attrValue = reader2.nextString();
            attributes = this.attributesFactory.concat(attributes, Attribute.of(attrName, String.class), new CoercingStringValueSnapshot(attrValue, this.instantiator));
        }
        reader2.endObject();
        return attributes;
    }

    private void consumeAny(JsonReader reader2) throws IOException {
        reader2.skipValue();
    }

    private void assertDefined(JsonReader reader2, String attribute, String value) {
        if (StringUtils.isEmpty((String)value)) {
            String path = reader2.getPath();
            throw new RuntimeException("missing '" + attribute + "' at " + path.substring(1, path.lastIndexOf(46)).replace('.', '/'));
        }
    }

    private static class VariantCapability
    implements Capability {
        final String group;
        final String name;
        final String version;

        private VariantCapability(String group, String name, String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @Override
        public String getGroup() {
            return this.group;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            return this.version;
        }
    }

    private static class ModuleDependencyConstraint {
        final String group;
        final String module;
        final VersionConstraint versionConstraint;
        final String reason;
        final ImmutableAttributes attributes;

        ModuleDependencyConstraint(String group, String module, VersionConstraint versionConstraint, String reason, ImmutableAttributes attributes) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.reason = reason;
            this.attributes = attributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependencyConstraint that = (ModuleDependencyConstraint)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal((Object)this.reason, (Object)that.reason) && Objects.equal((Object)this.attributes, (Object)that.attributes);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.module, this.versionConstraint, this.reason, this.attributes});
        }
    }

    private static class ModuleDependency {
        final String group;
        final String module;
        final VersionConstraint versionConstraint;
        final ImmutableList<ExcludeMetadata> excludes;
        final String reason;
        final ImmutableAttributes attributes;
        final List<? extends Capability> requestedCapabilities;
        final boolean endorsing;
        final IvyArtifactName artifact;

        ModuleDependency(String group, String module, VersionConstraint versionConstraint, ImmutableList<ExcludeMetadata> excludes, String reason, ImmutableAttributes attributes, List<? extends Capability> requestedCapabilities, boolean endorsing, IvyArtifactName artifact) {
            this.group = group;
            this.module = module;
            this.versionConstraint = versionConstraint;
            this.excludes = excludes;
            this.reason = reason;
            this.attributes = attributes;
            this.requestedCapabilities = requestedCapabilities;
            this.endorsing = endorsing;
            this.artifact = artifact;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModuleDependency that = (ModuleDependency)o;
            return Objects.equal((Object)this.group, (Object)that.group) && Objects.equal((Object)this.module, (Object)that.module) && Objects.equal((Object)this.versionConstraint, (Object)that.versionConstraint) && Objects.equal(this.excludes, that.excludes) && Objects.equal((Object)this.reason, (Object)that.reason) && Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal(this.requestedCapabilities, that.requestedCapabilities) && Objects.equal((Object)this.endorsing, (Object)that.endorsing) && Objects.equal((Object)this.artifact, (Object)that.artifact);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.group, this.module, this.versionConstraint, this.excludes, this.reason, this.attributes, this.endorsing, this.artifact});
        }
    }

    private static class ModuleFile {
        final String name;
        final String uri;

        ModuleFile(String name, String uri) {
            this.name = name;
            this.uri = uri;
        }
    }
}

