/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.UnavailableResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class DefaultVisitedArtifactResults
implements VisitedArtifactsResults {
    private static final Function<ResolvedArtifactSet, ResolvedArtifactSet> DO_NOTHING = resolvedArtifactSet -> resolvedArtifactSet;
    private static final Function<ResolvedArtifactSet, ResolvedArtifactSet> ALLOW_UNAVAILABLE = resolvedArtifactSet -> {
        if (resolvedArtifactSet instanceof UnavailableResolvedArtifactSet) {
            return ResolvedArtifactSet.EMPTY;
        }
        return resolvedArtifactSet;
    };
    private final ResolutionStrategy.SortOrder sortOrder;
    private final List<ArtifactSet> artifactsById;

    public DefaultVisitedArtifactResults(ResolutionStrategy.SortOrder sortOrder, List<ArtifactSet> artifactsById) {
        this.sortOrder = sortOrder;
        this.artifactsById = artifactsById;
    }

    private SelectedArtifactResults select(Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector, Function<ResolvedArtifactSet, ResolvedArtifactSet> artifactSetHandler) {
        if (this.artifactsById.isEmpty()) {
            return NoArtifactResults.INSTANCE;
        }
        ArrayList<ResolvedArtifactSet> resolvedArtifactSets = new ArrayList(this.artifactsById.size());
        for (ArtifactSet artifactSet : this.artifactsById) {
            ResolvedArtifactSet resolvedArtifacts = artifactSet.select(componentFilter, selector);
            resolvedArtifactSets.add(artifactSetHandler.apply(resolvedArtifacts));
        }
        if (this.sortOrder == ResolutionStrategy.SortOrder.DEPENDENCY_FIRST) {
            resolvedArtifactSets = Lists.reverse(resolvedArtifactSets);
        }
        ResolvedArtifactSet composite = CompositeResolvedArtifactSet.of(resolvedArtifactSets);
        return new DefaultSelectedArtifactResults(this.sortOrder, composite, resolvedArtifactSets);
    }

    @Override
    public SelectedArtifactResults select(Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector) {
        return this.select(componentFilter, selector, DO_NOTHING);
    }

    @Override
    public SelectedArtifactResults selectLenient(Spec<? super ComponentIdentifier> componentFilter, VariantSelector selector) {
        return this.select(componentFilter, selector, ALLOW_UNAVAILABLE);
    }

    private static class DefaultSelectedArtifactResults
    implements SelectedArtifactResults {
        private final ResolvedArtifactSet allArtifacts;
        private final ResolutionStrategy.SortOrder sortOrder;
        private final List<ResolvedArtifactSet> resolvedArtifactsById;

        DefaultSelectedArtifactResults(ResolutionStrategy.SortOrder sortOrder, ResolvedArtifactSet allArtifacts, List<ResolvedArtifactSet> resolvedArtifactsById) {
            this.sortOrder = sortOrder;
            this.allArtifacts = allArtifacts;
            this.resolvedArtifactsById = resolvedArtifactsById;
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return this.allArtifacts;
        }

        @Override
        public ResolvedArtifactSet getArtifactsWithId(int id) {
            if (this.sortOrder == ResolutionStrategy.SortOrder.DEPENDENCY_FIRST) {
                return this.resolvedArtifactsById.get(this.resolvedArtifactsById.size() - id - 1);
            }
            return this.resolvedArtifactsById.get(id);
        }
    }

    private static class NoArtifactResults
    implements SelectedArtifactResults {
        private static final NoArtifactResults INSTANCE = new NoArtifactResults();

        private NoArtifactResults() {
        }

        @Override
        public ResolvedArtifactSet getArtifacts() {
            return ResolvedArtifactSet.EMPTY;
        }

        @Override
        public ResolvedArtifactSet getArtifactsWithId(int id) {
            return ResolvedArtifactSet.EMPTY;
        }
    }
}

