/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.CapabilitySerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.result.DefaultResolvedVariantResult;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

@NotThreadSafe
public class ResolvedVariantResultSerializer
implements Serializer<ResolvedVariantResult> {
    private final Map<ResolvedVariantResult, Integer> written = Maps.newHashMap();
    private final List<ResolvedVariantResult> read = Lists.newArrayList();
    private final ComponentIdentifierSerializer componentIdentifierSerializer;
    private final AttributeContainerSerializer attributeContainerSerializer;
    private final CapabilitySerializer capabilitySerializer;

    public ResolvedVariantResultSerializer(ComponentIdentifierSerializer componentIdentifierSerializer, AttributeContainerSerializer attributeContainerSerializer) {
        this.componentIdentifierSerializer = componentIdentifierSerializer;
        this.attributeContainerSerializer = attributeContainerSerializer;
        this.capabilitySerializer = new CapabilitySerializer();
    }

    @Override
    public ResolvedVariantResult read(Decoder decoder) throws IOException {
        int index = decoder.readSmallInt();
        if (index == -1) {
            return null;
        }
        if (index == this.read.size()) {
            ComponentIdentifier owner = this.componentIdentifierSerializer.read(decoder);
            String variantName = decoder.readString();
            ImmutableAttributes attributes = this.attributeContainerSerializer.read(decoder);
            List<Capability> capabilities = this.readCapabilities(decoder);
            this.read.add(null);
            ResolvedVariantResult externalVariant = this.read(decoder);
            DefaultResolvedVariantResult result2 = new DefaultResolvedVariantResult(owner, Describables.of(variantName), attributes, capabilities, externalVariant);
            this.read.set(index, result2);
            return result2;
        }
        return this.read.get(index);
    }

    private List<Capability> readCapabilities(Decoder decoder) throws IOException {
        int size = decoder.readSmallInt();
        if (size == 0) {
            return ImmutableList.of();
        }
        ImmutableList.Builder capabilities = ImmutableList.builderWithExpectedSize((int)size);
        for (int i = 0; i < size; ++i) {
            capabilities.add((Object)this.capabilitySerializer.read(decoder));
        }
        return capabilities.build();
    }

    @Override
    public void write(Encoder encoder, ResolvedVariantResult variant) throws IOException {
        if (variant == null) {
            encoder.writeSmallInt(-1);
            return;
        }
        Integer index = this.written.get(variant);
        if (index == null) {
            index = this.written.size();
            this.written.put(variant, index);
            encoder.writeSmallInt(index);
            this.componentIdentifierSerializer.write(encoder, variant.getOwner());
            encoder.writeString(variant.getDisplayName());
            this.attributeContainerSerializer.write(encoder, variant.getAttributes());
            this.writeCapabilities(encoder, variant.getCapabilities());
            this.write(encoder, (ResolvedVariantResult)variant.getExternalVariant().orElse(null));
        } else {
            encoder.writeSmallInt(index);
        }
    }

    private void writeCapabilities(Encoder encoder, List<Capability> capabilities) throws IOException {
        encoder.writeSmallInt(capabilities.size());
        for (Capability capability : capabilities) {
            this.capabilitySerializer.write(encoder, capability);
        }
    }

    void reset() {
        this.written.clear();
        this.read.clear();
    }
}

