/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformDependencies;
import org.gradle.api.internal.artifacts.transform.ArtifactTransformListener;
import org.gradle.api.internal.artifacts.transform.TransformException;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.api.internal.artifacts.transform.TransformationResultSerializer;
import org.gradle.api.internal.artifacts.transform.TransformationSubject;
import org.gradle.api.internal.artifacts.transform.TransformationWorkspaceServices;
import org.gradle.api.internal.artifacts.transform.Transformer;
import org.gradle.api.internal.artifacts.transform.TransformerInvocationFactory;
import org.gradle.api.internal.file.DefaultFileSystemLocation;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Deferrable;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.UncategorizedBuildOperations;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.vfs.FileSystemAccess;

public class DefaultTransformerInvocationFactory
implements TransformerInvocationFactory {
    private static final CachingDisabledReason NOT_CACHEABLE = new CachingDisabledReason(CachingDisabledReasonCategory.NOT_CACHEABLE, "Caching not enabled.");
    private static final String INPUT_ARTIFACT_PROPERTY_NAME = "inputArtifact";
    private static final String INPUT_ARTIFACT_PATH_PROPERTY_NAME = "inputArtifactPath";
    private static final String INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME = "inputArtifactSnapshot";
    private static final String DEPENDENCIES_PROPERTY_NAME = "inputArtifactDependencies";
    private static final String SECONDARY_INPUTS_HASH_PROPERTY_NAME = "inputPropertiesHash";
    private static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "outputDirectory";
    private static final String RESULTS_FILE_PROPERTY_NAME = "resultsFile";
    private final ExecutionEngine executionEngine;
    private final FileSystemAccess fileSystemAccess;
    private final ArtifactTransformListener artifactTransformListener;
    private final TransformationWorkspaceServices immutableWorkspaceProvider;
    private final FileCollectionFactory fileCollectionFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildOperationExecutor buildOperationExecutor;

    public DefaultTransformerInvocationFactory(ExecutionEngine executionEngine, FileSystemAccess fileSystemAccess, ArtifactTransformListener artifactTransformListener, TransformationWorkspaceServices immutableWorkspaceProvider, FileCollectionFactory fileCollectionFactory, ProjectStateRegistry projectStateRegistry, BuildOperationExecutor buildOperationExecutor) {
        this.executionEngine = executionEngine;
        this.fileSystemAccess = fileSystemAccess;
        this.artifactTransformListener = artifactTransformListener;
        this.immutableWorkspaceProvider = immutableWorkspaceProvider;
        this.fileCollectionFactory = fileCollectionFactory;
        this.projectStateRegistry = projectStateRegistry;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    public Deferrable<Try<ImmutableList<File>>> createInvocation(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, TransformationSubject subject, InputFingerprinter inputFingerprinter) {
        ProjectInternal producerProject = this.determineProducerProject(subject);
        TransformationWorkspaceServices workspaceServices = this.determineWorkspaceServices(producerProject);
        AbstractTransformerExecution execution = producerProject == null ? new ImmutableTransformerExecution(transformer, inputArtifact, dependencies, subject, this.artifactTransformListener, this.buildOperationExecutor, this.fileCollectionFactory, inputFingerprinter, this.fileSystemAccess, workspaceServices) : new MutableTransformerExecution(transformer, inputArtifact, dependencies, subject, this.artifactTransformListener, this.buildOperationExecutor, this.fileCollectionFactory, inputFingerprinter, workspaceServices);
        return this.executionEngine.createRequest(execution).executeDeferred(workspaceServices.getIdentityCache()).map(result2 -> result2.map(successfulResult -> successfulResult.resolveOutputsForInputArtifact(inputArtifact)).mapFailure(failure -> new TransformException(String.format("Execution failed for %s.", execution.getDisplayName()), (Throwable)failure)));
    }

    private TransformationWorkspaceServices determineWorkspaceServices(@Nullable ProjectInternal producerProject) {
        if (producerProject == null) {
            return this.immutableWorkspaceProvider;
        }
        return producerProject.getServices().get(TransformationWorkspaceServices.class);
    }

    @Nullable
    private ProjectInternal determineProducerProject(TransformationSubject subject) {
        ComponentIdentifier componentIdentifier = subject.getInitialComponentIdentifier();
        if (componentIdentifier instanceof ProjectComponentIdentifier) {
            return this.projectStateRegistry.stateFor((ProjectComponentIdentifier)componentIdentifier).getMutableModel();
        }
        return null;
    }

    public static class MutableTransformationWorkspaceIdentity
    implements UnitOfWork.Identity {
        private final String inputArtifactAbsolutePath;
        private final ValueSnapshot secondaryInputsSnapshot;
        private final HashCode dependenciesHash;

        public MutableTransformationWorkspaceIdentity(String inputArtifactAbsolutePath, ValueSnapshot secondaryInputsSnapshot, HashCode dependenciesHash) {
            this.inputArtifactAbsolutePath = inputArtifactAbsolutePath;
            this.secondaryInputsSnapshot = secondaryInputsSnapshot;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getUniqueId() {
            Hasher hasher = Hashing.newHasher();
            hasher.putString(this.inputArtifactAbsolutePath);
            this.secondaryInputsSnapshot.appendToHasher(hasher);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MutableTransformationWorkspaceIdentity that = (MutableTransformationWorkspaceIdentity)o;
            if (!this.secondaryInputsSnapshot.equals(that.secondaryInputsSnapshot)) {
                return false;
            }
            if (!this.dependenciesHash.equals(that.dependenciesHash)) {
                return false;
            }
            return this.inputArtifactAbsolutePath.equals(that.inputArtifactAbsolutePath);
        }

        public int hashCode() {
            int result2 = this.inputArtifactAbsolutePath.hashCode();
            result2 = 31 * result2 + this.secondaryInputsSnapshot.hashCode();
            result2 = 31 * result2 + this.dependenciesHash.hashCode();
            return result2;
        }
    }

    private static class ImmutableTransformationWorkspaceIdentity
    implements UnitOfWork.Identity {
        private final ValueSnapshot inputArtifactPath;
        private final ValueSnapshot inputArtifactSnapshot;
        private final ValueSnapshot secondaryInputSnapshot;
        private final HashCode dependenciesHash;

        public ImmutableTransformationWorkspaceIdentity(ValueSnapshot inputArtifactPath, ValueSnapshot inputArtifactSnapshot, ValueSnapshot secondaryInputSnapshot, HashCode dependenciesHash) {
            this.inputArtifactPath = inputArtifactPath;
            this.inputArtifactSnapshot = inputArtifactSnapshot;
            this.secondaryInputSnapshot = secondaryInputSnapshot;
            this.dependenciesHash = dependenciesHash;
        }

        @Override
        public String getUniqueId() {
            Hasher hasher = Hashing.newHasher();
            this.inputArtifactPath.appendToHasher(hasher);
            this.inputArtifactSnapshot.appendToHasher(hasher);
            this.secondaryInputSnapshot.appendToHasher(hasher);
            hasher.putHash(this.dependenciesHash);
            return hasher.hash().toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTransformationWorkspaceIdentity that = (ImmutableTransformationWorkspaceIdentity)o;
            if (!this.inputArtifactPath.equals(that.inputArtifactPath)) {
                return false;
            }
            if (!this.inputArtifactSnapshot.equals(that.inputArtifactSnapshot)) {
                return false;
            }
            if (!this.secondaryInputSnapshot.equals(that.secondaryInputSnapshot)) {
                return false;
            }
            return this.dependenciesHash.equals(that.dependenciesHash);
        }

        public int hashCode() {
            int result2 = this.inputArtifactPath.hashCode();
            result2 = 31 * result2 + this.inputArtifactSnapshot.hashCode();
            result2 = 31 * result2 + this.secondaryInputSnapshot.hashCode();
            result2 = 31 * result2 + this.dependenciesHash.hashCode();
            return result2;
        }
    }

    private static abstract class AbstractTransformerExecution
    implements UnitOfWork {
        protected final Transformer transformer;
        protected final File inputArtifact;
        private final ArtifactTransformDependencies dependencies;
        private final TransformationSubject subject;
        private final ArtifactTransformListener artifactTransformListener;
        private final BuildOperationExecutor buildOperationExecutor;
        private final FileCollectionFactory fileCollectionFactory;
        private final Provider<FileSystemLocation> inputArtifactProvider;
        protected final InputFingerprinter inputFingerprinter;
        private final TransformationWorkspaceServices workspaceServices;

        public AbstractTransformerExecution(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, TransformationSubject subject, ArtifactTransformListener artifactTransformListener, BuildOperationExecutor buildOperationExecutor, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, TransformationWorkspaceServices workspaceServices) {
            this.transformer = transformer;
            this.inputArtifact = inputArtifact;
            this.dependencies = dependencies;
            this.inputArtifactProvider = Providers.of(new DefaultFileSystemLocation(inputArtifact));
            this.subject = subject;
            this.artifactTransformListener = artifactTransformListener;
            this.buildOperationExecutor = buildOperationExecutor;
            this.fileCollectionFactory = fileCollectionFactory;
            this.inputFingerprinter = inputFingerprinter;
            this.workspaceServices = workspaceServices;
        }

        @Override
        public UnitOfWork.WorkOutput execute(UnitOfWork.ExecutionRequest executionRequest) {
            this.artifactTransformListener.beforeTransformerInvocation(this.transformer, this.subject);
            try {
                UnitOfWork.WorkOutput workOutput = this.executeWithinTransformerListener(executionRequest);
                return workOutput;
            }
            finally {
                this.artifactTransformListener.afterTransformerInvocation(this.transformer, this.subject);
            }
        }

        private UnitOfWork.WorkOutput executeWithinTransformerListener(final UnitOfWork.ExecutionRequest executionRequest) {
            final TransformationResult result2 = this.buildOperationExecutor.call(new CallableBuildOperation<TransformationResult>(){

                @Override
                public TransformationResult call(BuildOperationContext context) {
                    File workspace = executionRequest.getWorkspace();
                    InputChangesInternal inputChanges = executionRequest.getInputChanges().orElse(null);
                    TransformationResult result2 = transformer.transform(inputArtifactProvider, AbstractTransformerExecution.getOutputDir(workspace), dependencies, inputChanges);
                    TransformationResultSerializer resultSerializer = new TransformationResultSerializer(AbstractTransformerExecution.getOutputDir(workspace));
                    resultSerializer.writeToFile(AbstractTransformerExecution.getResultsFile(workspace), result2);
                    return result2;
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    String displayName = transformer.getDisplayName() + " " + inputArtifact.getName();
                    return BuildOperationDescriptor.displayName(displayName).metadata(UncategorizedBuildOperations.TRANSFORM_ACTION).progressDisplayName(displayName);
                }
            });
            return new UnitOfWork.WorkOutput(){

                @Override
                public UnitOfWork.WorkResult getDidWork() {
                    return UnitOfWork.WorkResult.DID_WORK;
                }

                @Override
                public Object getOutput() {
                    return result2;
                }
            };
        }

        @Override
        public Object loadAlreadyProducedOutput(File workspace) {
            TransformationResultSerializer resultSerializer = new TransformationResultSerializer(AbstractTransformerExecution.getOutputDir(workspace));
            return resultSerializer.readResultsFile(AbstractTransformerExecution.getResultsFile(workspace));
        }

        @Override
        public WorkspaceProvider getWorkspaceProvider() {
            return this.workspaceServices.getWorkspaceProvider();
        }

        @Override
        public InputFingerprinter getInputFingerprinter() {
            return this.inputFingerprinter;
        }

        private static File getOutputDir(File workspace) {
            return new File(workspace, "transformed");
        }

        private static File getResultsFile(File workspace) {
            return new File(workspace, "results.bin");
        }

        @Override
        public Optional<Duration> getTimeout() {
            return Optional.empty();
        }

        @Override
        public UnitOfWork.ExecutionBehavior getExecutionBehavior() {
            return this.transformer.requiresInputChanges() ? UnitOfWork.ExecutionBehavior.INCREMENTAL : UnitOfWork.ExecutionBehavior.NON_INCREMENTAL;
        }

        @Override
        public void visitImplementations(UnitOfWork.ImplementationVisitor visitor) {
            visitor.visitImplementation(this.transformer.getImplementationClass());
        }

        @Override
        @OverridingMethodsMustInvokeSuper
        public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME, this.transformer::getSecondaryInputHash);
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PATH_PROPERTY_NAME, () -> this.transformer.getInputArtifactNormalizer() == InputNormalizer.ABSOLUTE_PATH ? this.inputArtifact.getAbsolutePath() : this.inputArtifact.getName());
            visitor.visitInputFileProperty(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME, InputBehavior.NON_INCREMENTAL, new UnitOfWork.InputFileValueSupplier(this.dependencies, this.transformer.getInputArtifactDependenciesNormalizer(), this.transformer.getInputArtifactDependenciesDirectorySensitivity(), this.transformer.getInputArtifactDependenciesLineEndingNormalization(), () -> this.dependencies.getFiles().orElse(FileCollectionFactory.empty())));
        }

        @Override
        @OverridingMethodsMustInvokeSuper
        public void visitRegularInputs(UnitOfWork.InputVisitor visitor) {
            visitor.visitInputFileProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PROPERTY_NAME, InputBehavior.INCREMENTAL, new UnitOfWork.InputFileValueSupplier(this.inputArtifactProvider, this.transformer.getInputArtifactNormalizer(), this.transformer.getInputArtifactDirectorySensitivity(), this.transformer.getInputArtifactLineEndingNormalization(), () -> this.fileCollectionFactory.fixed(this.inputArtifact)));
        }

        @Override
        public void visitOutputs(File workspace, UnitOfWork.OutputVisitor visitor) {
            File outputDir = AbstractTransformerExecution.getOutputDir(workspace);
            File resultsFile = AbstractTransformerExecution.getResultsFile(workspace);
            visitor.visitOutputProperty(DefaultTransformerInvocationFactory.OUTPUT_DIRECTORY_PROPERTY_NAME, TreeType.DIRECTORY, UnitOfWork.OutputFileValueSupplier.fromStatic(outputDir, this.fileCollectionFactory.fixed(outputDir)));
            visitor.visitOutputProperty(DefaultTransformerInvocationFactory.RESULTS_FILE_PROPERTY_NAME, TreeType.FILE, UnitOfWork.OutputFileValueSupplier.fromStatic(resultsFile, this.fileCollectionFactory.fixed(resultsFile)));
        }

        @Override
        public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
            return this.transformer.isCacheable() ? Optional.empty() : Optional.of(NOT_CACHEABLE);
        }

        @Override
        public String getDisplayName() {
            return this.transformer.getDisplayName() + ": " + this.inputArtifact;
        }
    }

    private static class MutableTransformerExecution
    extends AbstractTransformerExecution {
        public MutableTransformerExecution(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, TransformationSubject subject, ArtifactTransformListener artifactTransformListener, BuildOperationExecutor buildOperationExecutor, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, TransformationWorkspaceServices workspaceServices) {
            super(transformer, inputArtifact, dependencies, subject, artifactTransformListener, buildOperationExecutor, fileCollectionFactory, inputFingerprinter, workspaceServices);
        }

        @Override
        public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
            return new MutableTransformationWorkspaceIdentity(this.inputArtifact.getAbsolutePath(), identityInputs.get(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME), identityFileInputs.get(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME).getHash());
        }
    }

    private static class ImmutableTransformerExecution
    extends AbstractTransformerExecution {
        private final FileSystemAccess fileSystemAccess;

        public ImmutableTransformerExecution(Transformer transformer, File inputArtifact, ArtifactTransformDependencies dependencies, TransformationSubject subject, ArtifactTransformListener artifactTransformListener, BuildOperationExecutor buildOperationExecutor, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, FileSystemAccess fileSystemAccess, TransformationWorkspaceServices workspaceServices) {
            super(transformer, inputArtifact, dependencies, subject, artifactTransformListener, buildOperationExecutor, fileCollectionFactory, inputFingerprinter, workspaceServices);
            this.fileSystemAccess = fileSystemAccess;
        }

        @Override
        public void visitIdentityInputs(UnitOfWork.InputVisitor visitor) {
            super.visitIdentityInputs(visitor);
            FileSystemLocationSnapshot inputArtifactSnapshot = this.fileSystemAccess.read(this.inputArtifact.getAbsolutePath());
            visitor.visitInputProperty(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME, inputArtifactSnapshot::getHash);
        }

        @Override
        public UnitOfWork.Identity identify(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
            return new ImmutableTransformationWorkspaceIdentity(identityInputs.get(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_PATH_PROPERTY_NAME), identityInputs.get(DefaultTransformerInvocationFactory.INPUT_ARTIFACT_SNAPSHOT_PROPERTY_NAME), identityInputs.get(DefaultTransformerInvocationFactory.SECONDARY_INPUTS_HASH_PROPERTY_NAME), identityFileInputs.get(DefaultTransformerInvocationFactory.DEPENDENCIES_PROPERTY_NAME).getHash());
        }
    }
}

