/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.component;

import java.util.Map;
import org.gradle.api.component.Artifact;
import org.gradle.api.component.Component;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.api.internal.component.ComponentTypeRegistration;
import org.gradle.api.internal.component.ComponentTypeRegistry;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultComponentTypeRegistry
implements ComponentTypeRegistry {
    private final Map<Class<? extends Component>, ComponentTypeRegistration> componentRegistrations = Maps.newHashMap();

    @Override
    public ComponentTypeRegistration maybeRegisterComponentType(Class<? extends Component> componentType) {
        ComponentTypeRegistration registration = this.componentRegistrations.get(componentType);
        if (registration == null) {
            registration = new DefaultComponentTypeRegistration(componentType);
            this.componentRegistrations.put(componentType, registration);
        }
        return registration;
    }

    @Override
    public ComponentTypeRegistration getComponentRegistration(Class<? extends Component> componentType) {
        ComponentTypeRegistration registration = this.componentRegistrations.get(componentType);
        if (registration == null) {
            throw new IllegalArgumentException(String.format("Not a registered component type: %s.", componentType.getName()));
        }
        return registration;
    }

    private static class DefaultComponentTypeRegistration
    implements ComponentTypeRegistration {
        private final Class<? extends Component> componentType;
        private final Map<Class<? extends Artifact>, ArtifactType> typeRegistrations = Maps.newHashMap();

        private DefaultComponentTypeRegistration(Class<? extends Component> componentType) {
            this.componentType = componentType;
        }

        @Override
        public ArtifactType getArtifactType(Class<? extends Artifact> artifact) {
            ArtifactType type = this.typeRegistrations.get(artifact);
            if (type == null) {
                throw new IllegalArgumentException(String.format("Artifact type %s is not registered for component type %s.", artifact.getName(), this.componentType.getName()));
            }
            return type;
        }

        @Override
        public ComponentTypeRegistration registerArtifactType(Class<? extends Artifact> artifact, ArtifactType artifactType) {
            if (this.typeRegistrations.containsKey(artifact)) {
                throw new IllegalStateException(String.format("Artifact type %s is already registered for component type %s.", artifact.getName(), this.componentType.getName()));
            }
            this.typeRegistrations.put(artifact, artifactType);
            return this;
        }
    }
}

