/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.java.usagecontext;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.ConfigurationVariant;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.java.usagecontext.ConfigurationVariantDetailsInternal;
import org.gradle.api.internal.java.usagecontext.FeatureConfigurationVariant;
import org.gradle.internal.Actions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.Instantiator;

public class ConfigurationVariantMapping {
    private final ConfigurationInternal outgoingConfiguration;
    private Action<? super ConfigurationVariantDetails> action;
    private final Instantiator instantiator;

    public ConfigurationVariantMapping(ConfigurationInternal outgoingConfiguration, Action<? super ConfigurationVariantDetails> action, Instantiator instantiator2) {
        this.outgoingConfiguration = outgoingConfiguration;
        this.action = action;
        this.instantiator = instantiator2;
    }

    private void assertNoDuplicateVariant(String name, Set<String> seen) {
        if (!seen.add(name)) {
            throw new InvalidUserDataException("Cannot add feature variant '" + name + "' as a variant with the same name is already registered");
        }
    }

    public void addAction(Action<? super ConfigurationVariantDetails> action) {
        this.action = Actions.composite(this.action, action);
    }

    public void collectVariants(ImmutableCollection.Builder<UsageContext> outgoing) {
        if (!this.outgoingConfiguration.isTransitive()) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.warnOfChangedBehaviour("Publication ignores 'transitive = false' at configuration level", "Consider using 'transitive = false' at the dependency level if you need this to be published.").withUserManual("publishing_ivy", "configurations_marked_as_non_transitive")).nagUser();
        }
        HashSet seen = Sets.newHashSet();
        ConfigurationVariant defaultConfigurationVariant = this.instantiator.newInstance(DefaultConfigurationVariant.class, this.outgoingConfiguration);
        ConfigurationVariantDetailsInternal details = this.instantiator.newInstance(DefaultConfigurationVariantDetails.class, defaultConfigurationVariant);
        this.action.execute(details);
        String outgoingConfigurationName = this.outgoingConfiguration.getName();
        if (details.shouldPublish()) {
            this.registerVariant(outgoing, seen, defaultConfigurationVariant, outgoingConfigurationName, details.getMavenScope(), details.isOptional());
        }
        NamedDomainObjectContainer<ConfigurationVariant> extraVariants = this.outgoingConfiguration.getOutgoing().getVariants();
        for (ConfigurationVariant variant : extraVariants) {
            details = new DefaultConfigurationVariantDetails(variant);
            this.action.execute(details);
            if (!details.shouldPublish()) continue;
            String name = outgoingConfigurationName + StringUtils.capitalize((String)variant.getName());
            this.registerVariant(outgoing, seen, variant, name, details.getMavenScope(), details.isOptional());
        }
    }

    private void registerVariant(ImmutableCollection.Builder<UsageContext> outgoing, Set<String> seen, ConfigurationVariant variant, String name, String scope, boolean optional) {
        this.assertNoDuplicateVariant(name, seen);
        outgoing.add((Object)new FeatureConfigurationVariant(name, this.outgoingConfiguration, variant, scope, optional));
    }

    static class DefaultConfigurationVariantDetails
    implements ConfigurationVariantDetailsInternal {
        private final ConfigurationVariant variant;
        private boolean skip = false;
        private String mavenScope = "compile";
        private boolean optional = false;

        public DefaultConfigurationVariantDetails(ConfigurationVariant variant) {
            this.variant = variant;
        }

        @Override
        public ConfigurationVariant getConfigurationVariant() {
            return this.variant;
        }

        @Override
        public void skip() {
            this.skip = true;
        }

        @Override
        public void mapToOptional() {
            this.optional = true;
        }

        @Override
        public void mapToMavenScope(String scope) {
            this.mavenScope = DefaultConfigurationVariantDetails.assertValidScope(scope);
        }

        private static String assertValidScope(String scope) {
            if ("compile".equals(scope = scope.toLowerCase()) || "runtime".equals(scope)) {
                return scope;
            }
            throw new InvalidUserCodeException("Invalid Maven scope '" + scope + "'. You must choose between 'compile' and 'runtime'");
        }

        @Override
        public boolean shouldPublish() {
            return !this.skip;
        }

        @Override
        public String getMavenScope() {
            return this.mavenScope;
        }

        @Override
        public boolean isOptional() {
            return this.optional;
        }
    }

    static class DefaultConfigurationVariant
    implements ConfigurationVariant {
        private final ConfigurationInternal outgoingConfiguration;

        public DefaultConfigurationVariant(ConfigurationInternal outgoingConfiguration) {
            this.outgoingConfiguration = outgoingConfiguration;
        }

        @Override
        public PublishArtifactSet getArtifacts() {
            return this.outgoingConfiguration.getArtifacts();
        }

        @Override
        public void artifact(Object notation) {
            throw new InvalidUserCodeException("Cannot add artifacts during filtering");
        }

        @Override
        public void artifact(Object notation, Action<? super ConfigurablePublishArtifact> configureAction) {
            throw new InvalidUserCodeException("Cannot add artifacts during filtering");
        }

        @Override
        public String getName() {
            return this.outgoingConfiguration.getName();
        }

        @Override
        public Optional<String> getDescription() {
            return Optional.ofNullable(this.outgoingConfiguration.getDescription());
        }

        @Override
        public ConfigurationVariant attributes(Action<? super AttributeContainer> action) {
            throw new InvalidUserCodeException("Cannot mutate outgoing configuration during filtering");
        }

        @Override
        public AttributeContainer getAttributes() {
            this.outgoingConfiguration.preventFromFurtherMutation();
            return this.outgoingConfiguration.getAttributes();
        }
    }
}

