/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.Map;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;

class ValidatingMapEntryCollector<K, V>
implements MapEntryCollector<K, V> {
    private final Class<K> keyType;
    private final Class<V> valueType;
    private final ValueSanitizer<K> keySanitizer;
    private final ValueSanitizer<V> valueSanitizer;

    public ValidatingMapEntryCollector(Class<K> keyType, Class<V> valueType, ValueSanitizer<K> keySanitizer, ValueSanitizer<V> valueSanitizer) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySanitizer = keySanitizer;
        this.valueSanitizer = valueSanitizer;
    }

    @Override
    public void add(K key, V value, Map<K, V> dest) {
        Preconditions.checkNotNull(key, (String)"Cannot get the value of a property of type %s with key type %s as the source contains a null key.", (Object)Map.class.getName(), (Object)this.keyType.getName());
        Preconditions.checkNotNull(value, (String)"Cannot get the value of a property of type %s with value type %s as the source contains a null value for key \"%s\".", (Object)Map.class.getName(), (Object)this.valueType.getName(), key);
        K sanitizedKey = this.keySanitizer.sanitize(key);
        if (!this.keyType.isInstance(sanitizedKey)) {
            throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s with key type %s as the source contains a key of type %s.", Map.class.getName(), this.keyType.getName(), key.getClass().getName()));
        }
        V sanitizedValue = this.valueSanitizer.sanitize(value);
        if (!this.valueType.isInstance(sanitizedValue)) {
            throw new IllegalArgumentException(String.format("Cannot get the value of a property of type %s with value type %s as the source contains a value of type %s.", Map.class.getName(), this.valueType.getName(), value.getClass().getName()));
        }
        dest.put(sanitizedKey, sanitizedValue);
    }

    @Override
    public void addAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Map<K, V> dest) {
        for (Map.Entry<K, V> entry : entries) {
            this.add(entry.getKey(), entry.getValue(), dest);
        }
    }
}

