/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources.process;

import java.nio.charset.Charset;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.provider.sources.process.ProcessOutputValueSource;
import org.gradle.api.provider.Provider;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecResult;

public class DefaultExecOutput
implements ExecOutput {
    private final Provider<ProcessOutputValueSource.ExecOutputData> dataProvider;

    public DefaultExecOutput(Provider<ProcessOutputValueSource.ExecOutputData> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public Provider<ExecResult> getResult() {
        return this.dataProvider.map(SerializableLambdas.transformer(ProcessOutputValueSource.ExecOutputData::getResult));
    }

    @Override
    public ExecOutput.StandardStreamContent getStandardOutput() {
        return new DefaultStandardStreamContent(this.dataProvider.map(SerializableLambdas.transformer(ProcessOutputValueSource.ExecOutputData::getOutput)));
    }

    @Override
    public ExecOutput.StandardStreamContent getStandardError() {
        return new DefaultStandardStreamContent(this.dataProvider.map(SerializableLambdas.transformer(ProcessOutputValueSource.ExecOutputData::getError)));
    }

    private static class DefaultStandardStreamContent
    implements ExecOutput.StandardStreamContent {
        private final Provider<byte[]> bytesProvider;

        public DefaultStandardStreamContent(Provider<byte[]> bytesProvider) {
            this.bytesProvider = bytesProvider;
        }

        @Override
        public Provider<String> getAsText() {
            return this.getAsBytes().map(SerializableLambdas.transformer(bytes -> new String((byte[])bytes, Charset.defaultCharset())));
        }

        @Override
        public Provider<byte[]> getAsBytes() {
            return this.bytesProvider;
        }
    }
}

