/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps;

import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.DependentsSet;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;
import org.gradle.api.internal.tasks.compile.incremental.serialization.HierarchicalNameSerializer;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class DependentSetSerializer
extends AbstractSerializer<DependentsSet> {
    private final Supplier<HierarchicalNameSerializer> hierarchicalNameSerializerSupplier;

    public DependentSetSerializer(Supplier<HierarchicalNameSerializer> hierarchicalNameSerializerSupplier) {
        this.hierarchicalNameSerializerSupplier = hierarchicalNameSerializerSupplier;
    }

    @Override
    public DependentsSet read(Decoder decoder) throws Exception {
        HierarchicalNameSerializer nameSerializer = this.hierarchicalNameSerializerSupplier.get();
        byte b = decoder.readByte();
        if (b == 0) {
            return DependentsSet.dependencyToAll(decoder.readString());
        }
        ImmutableSet.Builder privateBuilder = ImmutableSet.builder();
        int count = decoder.readSmallInt();
        for (int i = 0; i < count; ++i) {
            privateBuilder.add((Object)nameSerializer.read(decoder));
        }
        ImmutableSet.Builder accessibleBuilder = ImmutableSet.builder();
        count = decoder.readSmallInt();
        for (int i = 0; i < count; ++i) {
            accessibleBuilder.add((Object)nameSerializer.read(decoder));
        }
        ImmutableSet.Builder resourceBuilder = ImmutableSet.builder();
        count = decoder.readSmallInt();
        for (int i = 0; i < count; ++i) {
            GeneratedResource.Location location = GeneratedResource.Location.values()[decoder.readSmallInt()];
            String path = nameSerializer.read(decoder);
            resourceBuilder.add((Object)new GeneratedResource(location, path));
        }
        return DependentsSet.dependents((Set<String>)privateBuilder.build(), (Set<String>)accessibleBuilder.build(), (Set<GeneratedResource>)resourceBuilder.build());
    }

    @Override
    public void write(Encoder encoder, DependentsSet dependentsSet) throws Exception {
        HierarchicalNameSerializer nameSerializer = this.hierarchicalNameSerializerSupplier.get();
        if (dependentsSet.isDependencyToAll()) {
            encoder.writeByte((byte)0);
            encoder.writeString(dependentsSet.getDescription());
        } else {
            encoder.writeByte((byte)1);
            encoder.writeSmallInt(dependentsSet.getPrivateDependentClasses().size());
            for (String className : dependentsSet.getPrivateDependentClasses()) {
                nameSerializer.write(encoder, className);
            }
            encoder.writeSmallInt(dependentsSet.getAccessibleDependentClasses().size());
            for (String className : dependentsSet.getAccessibleDependentClasses()) {
                nameSerializer.write(encoder, className);
            }
            encoder.writeSmallInt(dependentsSet.getDependentResources().size());
            for (GeneratedResource resource : dependentsSet.getDependentResources()) {
                encoder.writeSmallInt(resource.getLocation().ordinal());
                nameSerializer.write(encoder, resource.getPath());
            }
        }
    }
}

