/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.logging;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class StackTraceFilter {
    private final Spec<StackTraceElement> filterSpec;

    public StackTraceFilter(Spec<StackTraceElement> filterSpec) {
        this.filterSpec = filterSpec;
    }

    public List<StackTraceElement> filter(List<StackTraceElement> stackTrace) {
        ArrayList filtered = Lists.newArrayList();
        for (StackTraceElement element : Lists.reverse(stackTrace)) {
            if (!this.filterSpec.isSatisfiedBy(element)) continue;
            filtered.add(element);
        }
        if (filtered.isEmpty()) {
            return stackTrace;
        }
        return Lists.reverse((List)filtered);
    }

    public List<StackTraceElement> filter(Throwable throwable) {
        return this.filter(Arrays.asList(throwable.getStackTrace()));
    }
}

