/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.java.WebApplication;
import org.gradle.api.internal.plugins.DefaultArtifactPublicationSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.WarPluginConvention;
import org.gradle.api.plugins.internal.DefaultWarPluginConvention;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.tasks.bundling.War;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public abstract class WarPlugin
implements Plugin<Project> {
    public static final String PROVIDED_COMPILE_CONFIGURATION_NAME = "providedCompile";
    public static final String PROVIDED_RUNTIME_CONFIGURATION_NAME = "providedRuntime";
    public static final String WAR_TASK_NAME = "war";
    @Deprecated
    public static final String WEB_APP_GROUP = "web application";
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private Project project;
    private JvmFeatureInternal mainFeature;

    @Inject
    public WarPlugin(ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        this.project = project;
        this.mainFeature = JavaPluginHelper.getJavaComponent(project).getMainFeature();
        WarPluginConvention pluginConvention = this.objectFactory.newInstance(DefaultWarPluginConvention.class, project);
        DeprecationLogger.whileDisabled(() -> project.getConvention().getPlugins().put(WAR_TASK_NAME, pluginConvention));
        project.getTasks().withType(War.class).configureEach(task -> {
            task.getWebAppDirectory().convention(project.getLayout().dir(project.provider(() -> DeprecationLogger.whileDisabled(() -> pluginConvention.getWebAppDir()))));
            task.from(task.getWebAppDirectory());
            task.dependsOn(() -> this.mainFeature.getSourceSet().getRuntimeClasspath());
            task.classpath(() -> {
                Configuration providedRuntime = project.getConfigurations().getByName(PROVIDED_RUNTIME_CONFIGURATION_NAME);
                return this.mainFeature.getSourceSet().getRuntimeClasspath().minus(providedRuntime);
            });
        });
        NamedDomainObjectProvider war = project.getTasks().register(WAR_TASK_NAME, War.class, warTask -> {
            warTask.setDescription("Generates a war archive with all the compiled classes, the web-app content and the libraries.");
            warTask.setGroup("build");
        });
        LazyPublishArtifact warArtifact = new LazyPublishArtifact(war, ((ProjectInternal)project).getFileResolver(), ((ProjectInternal)project).getTaskDependencyFactory());
        project.getExtensions().getByType(DefaultArtifactPublicationSet.class).addCandidate(warArtifact);
        this.configureConfigurations(((ProjectInternal)project).getConfigurations(), this.mainFeature);
        this.configureComponent(project, warArtifact);
    }

    @Deprecated
    public void configureConfigurations(ConfigurationContainer configurationContainer) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(WarPlugin.class, "configureConfigurations(ConfigurationContainer)").willBeRemovedInGradle9().withUpgradeGuideSection(8, "war_plugin_configure_configurations")).nagUser();
        this.configureConfigurations((RoleBasedConfigurationContainerInternal)configurationContainer, this.mainFeature);
    }

    private void configureConfigurations(RoleBasedConfigurationContainerInternal configurationContainer, JvmFeatureInternal mainFeature) {
        Configuration providedCompileConfiguration = configurationContainer.resolvableBucket(PROVIDED_COMPILE_CONFIGURATION_NAME).setVisible(false).setDescription("Additional compile classpath for libraries that should not be part of the WAR archive.");
        Configuration providedRuntimeConfiguration = configurationContainer.resolvableBucket(PROVIDED_RUNTIME_CONFIGURATION_NAME).setVisible(false).extendsFrom(providedCompileConfiguration).setDescription("Additional runtime classpath for libraries that should not be part of the WAR archive.");
        mainFeature.getImplementationConfiguration().extendsFrom(providedCompileConfiguration);
        mainFeature.getRuntimeClasspathConfiguration().extendsFrom(providedRuntimeConfiguration);
        mainFeature.getRuntimeElementsConfiguration().extendsFrom(providedRuntimeConfiguration);
        JvmTestSuite defaultTestSuite = JavaPluginHelper.getDefaultTestSuite(this.project);
        configurationContainer.getByName(defaultTestSuite.getSources().getRuntimeClasspathConfigurationName()).extendsFrom(providedRuntimeConfiguration);
    }

    private void configureComponent(Project project, PublishArtifact warArtifact) {
        AttributeContainer attributes = this.attributesFactory.mutable().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime"));
        project.getComponents().add((SoftwareComponent)this.objectFactory.newInstance(WebApplication.class, warArtifact, "master", attributes));
    }
}

