/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.java.usagecontext.ConfigurationVariantMapping;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.reflect.Instantiator;

public class DefaultAdhocSoftwareComponent
implements AdhocComponentWithVariants,
SoftwareComponentInternal {
    private final String componentName;
    private final Map<Configuration, ConfigurationVariantMapping> variants = Maps.newLinkedHashMapWithExpectedSize((int)4);
    private final Instantiator instantiator;
    private boolean finalized = false;

    public DefaultAdhocSoftwareComponent(String componentName, Instantiator instantiator2) {
        this.componentName = componentName;
        this.instantiator = instantiator2;
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public void addVariantsFromConfiguration(Configuration outgoingConfiguration, Action<? super ConfigurationVariantDetails> spec) {
        this.checkNotFinalized();
        this.variants.put(outgoingConfiguration, new ConfigurationVariantMapping((ConfigurationInternal)outgoingConfiguration, spec, this.instantiator));
    }

    @Override
    public void withVariantsFromConfiguration(Configuration outgoingConfiguration, Action<? super ConfigurationVariantDetails> action) {
        this.checkNotFinalized();
        if (!this.variants.containsKey(outgoingConfiguration)) {
            throw new InvalidUserDataException("Variant for configuration " + outgoingConfiguration.getName() + " does not exist in component " + this.componentName);
        }
        this.variants.get(outgoingConfiguration).addAction(action);
    }

    @Override
    public Set<? extends UsageContext> getUsages() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (ConfigurationVariantMapping variant : this.variants.values()) {
            variant.collectVariants((ImmutableCollection.Builder<UsageContext>)builder);
        }
        return builder.build();
    }

    protected boolean isRegisteredAsLegacyVariant(Configuration outgoingConfiguration) {
        return this.variants.containsKey(outgoingConfiguration);
    }

    @Override
    public void finalizeValue() {
        this.finalized = true;
    }

    protected void checkNotFinalized() {
        if (this.finalized) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour("Gradle Module Metadata is modified after an eagerly populated publication.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "gmm_modification_after_publication_populated")).nagUser();
        }
    }
}

