/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;
import org.gradle.testing.base.TestSuite;
import org.gradle.testing.base.TestingExtension;

public class JavaPluginHelper {
    private JavaPluginHelper() {
    }

    public static JvmSoftwareComponentInternal getJavaComponent(Project project) {
        SoftwareComponent component = (SoftwareComponent)project.getComponents().findByName("java");
        if (!(component instanceof JvmSoftwareComponentInternal)) {
            throw new GradleException("The Java plugin must be applied to access the java component.");
        }
        return (JvmSoftwareComponentInternal)component;
    }

    public static JvmTestSuite getDefaultTestSuite(Project project) {
        String message2 = "The Java plugin must be applied to access the default test suite.";
        TestingExtension testing = project.getExtensions().findByType(TestingExtension.class);
        if (testing == null) {
            throw new GradleException(message2);
        }
        TestSuite defaultTestSuite = (TestSuite)testing.getSuites().findByName("test");
        if (!(defaultTestSuite instanceof JvmTestSuite)) {
            throw new GradleException(message2);
        }
        return (JvmTestSuite)defaultTestSuite;
    }
}

