/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.jvm.internal;

import java.util.function.Function;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.plugins.jvm.internal.JvmLanguageGeneratedSourceDirectoryBuilder;
import org.gradle.api.plugins.jvm.internal.JvmLanguageSourceDirectoryBuilder;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class DefaultJvmLanguageGeneratedSourceDirectoryBuilder
implements JvmLanguageGeneratedSourceDirectoryBuilder {
    private final ProjectInternal project;
    private final SourceSet sourceSet;
    private String description;
    private Function<DirectoryProperty, TaskProvider<? extends AbstractCompile>> taskBuilder;
    private TaskProvider<? extends Task> sourceTaskProvider;
    private Function<? extends Task, DirectoryProperty> mapping;
    private boolean includeInAllJava;

    @Inject
    public DefaultJvmLanguageGeneratedSourceDirectoryBuilder(ProjectInternal project, SourceSet sourceSet) {
        this.project = project;
        this.sourceSet = sourceSet;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledBy(Function<DirectoryProperty, TaskProvider<? extends AbstractCompile>> taskBuilder) {
        this.taskBuilder = taskBuilder;
        return this;
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder compiledWithJava(Action<? super JavaCompile> compilerConfiguration) {
        this.includeInAllJava();
        return this.compiledBy(sourceDirectory -> {
            String compileTaskName = "compile" + StringUtils.capitalize((String)this.sourceTaskProvider.getName());
            return this.project.getTasks().register(compileTaskName, JavaCompile.class, compileTask -> {
                compileTask.setDescription("Compile task for " + this.description);
                compileTask.source(sourceDirectory);
                compileTask.setClasspath(this.sourceSet.getCompileClasspath());
                compileTask.getDestinationDirectory().set(this.project.getLayout().getBuildDirectory().dir("classes/" + compileTaskName + "/" + this.sourceSet.getName()));
                compilerConfiguration.execute((JavaCompile)compileTask);
            });
        });
    }

    @Override
    public JvmLanguageSourceDirectoryBuilder includeInAllJava() {
        this.includeInAllJava = true;
        return this;
    }

    void build() {
        if (this.taskBuilder == null) {
            throw new IllegalStateException("You must specify how sources will be compiled either by calling compiledWithJava or compiledBy");
        }
        if (this.mapping == null) {
            throw new IllegalStateException("You must specify the mapping function from your source generating task to a directory property");
        }
        if (this.sourceTaskProvider == null) {
            throw new IllegalStateException("You must specify the source generation task");
        }
        Provider sourceDirectory = this.sourceTaskProvider.flatMap(task -> this.mapping.apply((Task)Cast.uncheckedCast(task)));
        TaskProvider<? extends AbstractCompile> compileTask = this.taskBuilder.apply((DirectoryProperty)this.project.getObjects().directoryProperty().convention(sourceDirectory));
        DefaultSourceSetOutput sourceSetOutput = Cast.cast(DefaultSourceSetOutput.class, this.sourceSet.getOutput());
        sourceSetOutput.getClassesDirs().from(compileTask.flatMap(AbstractCompile::getDestinationDirectory));
        sourceSetOutput.getGeneratedSourcesDirs().from(sourceDirectory);
        this.project.getTasks().matching(DefaultJvmLanguageGeneratedSourceDirectoryBuilder::isClassesTask).configureEach(classes -> classes.dependsOn(compileTask));
        if (this.includeInAllJava) {
            this.sourceSet.getAllJava().srcDir(sourceDirectory);
        }
        this.sourceSet.getAllSource().srcDir(sourceDirectory);
    }

    private static boolean isClassesTask(Task t) {
        return "classes".equals(t.getName());
    }

    @Override
    public <T extends Task> JvmLanguageGeneratedSourceDirectoryBuilder forSourceGeneratingTask(TaskProvider<T> taskProvider, Function<T, DirectoryProperty> mapping) {
        this.sourceTaskProvider = taskProvider;
        this.mapping = mapping;
        return this;
    }
}

