/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.ArchiveTaskBasedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.FileBasedMavenArtifact;
import org.gradle.api.publish.maven.internal.artifact.PublishArtifactBasedMavenArtifact;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.MapKey;
import org.gradle.internal.typeconversion.MapNotationConverter;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

public class MavenArtifactNotationParserFactory
implements Factory<NotationParser<Object, MavenArtifact>> {
    private final Instantiator instantiator;
    private final FileResolver fileResolver;
    private final TaskDependencyFactory taskDependencyFactory;

    public MavenArtifactNotationParserFactory(Instantiator instantiator2, FileResolver fileResolver, TaskDependencyFactory taskDependencyFactory) {
        this.instantiator = instantiator2;
        this.fileResolver = fileResolver;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    @Override
    public NotationParser<Object, MavenArtifact> create() {
        FileNotationConverter fileNotationConverter = new FileNotationConverter(this.fileResolver);
        ArchiveTaskNotationConverter archiveTaskNotationConverter = new ArchiveTaskNotationConverter();
        PublishArtifactNotationConverter publishArtifactNotationConverter = new PublishArtifactNotationConverter();
        ProviderNotationConverter providerNotationConverter = new ProviderNotationConverter();
        NotationParser<Object, MavenArtifact> sourceNotationParser = NotationParserBuilder.toType(MavenArtifact.class).fromType(Provider.class, (NotationConverter)Cast.uncheckedCast(providerNotationConverter)).fromType(AbstractArchiveTask.class, archiveTaskNotationConverter).fromType(PublishArtifact.class, publishArtifactNotationConverter).converter(fileNotationConverter).toComposite();
        MavenArtifactMapNotationConverter mavenArtifactMapNotationConverter = new MavenArtifactMapNotationConverter(sourceNotationParser);
        return NotationParserBuilder.toType(MavenArtifact.class).fromType(AbstractArchiveTask.class, archiveTaskNotationConverter).fromType(PublishArtifact.class, publishArtifactNotationConverter).fromType(Provider.class, (NotationConverter)Cast.uncheckedCast(providerNotationConverter)).converter(mavenArtifactMapNotationConverter).converter(fileNotationConverter).toComposite();
    }

    private static class MavenArtifactMapNotationConverter
    extends MapNotationConverter<MavenArtifact> {
        private final NotationParser<Object, MavenArtifact> sourceNotationParser;

        private MavenArtifactMapNotationConverter(NotationParser<Object, MavenArtifact> sourceNotationParser) {
            this.sourceNotationParser = sourceNotationParser;
        }

        protected MavenArtifact parseMap(@MapKey(value="source") Object source) {
            return this.sourceNotationParser.parseNotation(source);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Maps containing a 'source' entry").example("[source: '/path/to/file', extension: 'zip']");
        }
    }

    private class FileNotationConverter
    implements NotationConverter<Object, MavenArtifact> {
        private final NotationParser<Object, File> fileResolverNotationParser;

        private FileNotationConverter(FileResolver fileResolver) {
            this.fileResolverNotationParser = fileResolver.asNotationParser();
        }

        @Override
        public void convert(Object notation, NotationConvertResult<? super MavenArtifact> result2) throws TypeConversionException {
            File file = this.fileResolverNotationParser.parseNotation(notation);
            MavenArtifact mavenArtifact = MavenArtifactNotationParserFactory.this.instantiator.newInstance(FileBasedMavenArtifact.class, file, MavenArtifactNotationParserFactory.this.taskDependencyFactory);
            if (notation instanceof TaskDependencyContainer) {
                TaskDependencyContainer taskDependencyContainer = notation instanceof Provider ? context -> context.add(notation) : (TaskDependencyContainer)notation;
                mavenArtifact.builtBy(taskDependencyContainer);
            }
            result2.converted(mavenArtifact);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            this.fileResolverNotationParser.describe(visitor);
        }
    }

    private class ProviderNotationConverter
    implements NotationConverter<Provider<? extends AbstractArchiveTask>, MavenArtifact> {
        private ProviderNotationConverter() {
        }

        @Override
        public void convert(Provider<? extends AbstractArchiveTask> artifactTaskProvider, NotationConvertResult<? super MavenArtifact> result2) throws TypeConversionException {
            MavenArtifact artifact = MavenArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedMavenArtifact.class, new LazyPublishArtifact(artifactTaskProvider, MavenArtifactNotationParserFactory.this.fileResolver, MavenArtifactNotationParserFactory.this.taskDependencyFactory), MavenArtifactNotationParserFactory.this.taskDependencyFactory);
            result2.converted(artifact);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of Provider");
        }
    }

    private class PublishArtifactNotationConverter
    implements NotationConverter<PublishArtifact, MavenArtifact> {
        private PublishArtifactNotationConverter() {
        }

        @Override
        public void convert(PublishArtifact publishArtifact, NotationConvertResult<? super MavenArtifact> result2) throws TypeConversionException {
            MavenArtifact artifact = MavenArtifactNotationParserFactory.this.instantiator.newInstance(PublishArtifactBasedMavenArtifact.class, publishArtifact, MavenArtifactNotationParserFactory.this.taskDependencyFactory);
            result2.converted(artifact);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of PublishArtifact");
        }
    }

    private class ArchiveTaskNotationConverter
    implements NotationConverter<AbstractArchiveTask, MavenArtifact> {
        private ArchiveTaskNotationConverter() {
        }

        @Override
        public void convert(AbstractArchiveTask archiveTask, NotationConvertResult<? super MavenArtifact> result2) throws TypeConversionException {
            MavenArtifact artifact = MavenArtifactNotationParserFactory.this.instantiator.newInstance(ArchiveTaskBasedMavenArtifact.class, archiveTask, MavenArtifactNotationParserFactory.this.taskDependencyFactory);
            result2.converted(artifact);
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.candidate("Instances of AbstractArchiveTask").example("jar");
        }
    }
}

