/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.model.internal;

import java.util.TreeMap;
import java.util.stream.Collectors;
import org.gradle.api.reporting.model.ModelReport;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.registry.ModelReferenceNode;
import org.gradle.model.internal.type.ModelType;
import org.gradle.reporting.ReportRenderer;

public class ModelNodeRenderer
extends ReportRenderer<ModelNode, TextReportBuilder> {
    private static final int LABEL_LENGTH = 7;
    private final boolean showHidden;
    private final ModelReport.Format format;

    public ModelNodeRenderer(boolean showHidden, ModelReport.Format format) {
        this.showHidden = showHidden;
        this.format = format;
    }

    private boolean omitDetails() {
        return ModelReport.Format.SHORT == this.format;
    }

    @Override
    public void render(ModelNode model, TextReportBuilder output) {
        if (model.isHidden() && !this.showHidden) {
            return;
        }
        StyledTextOutput styledTextoutput = output.getOutput();
        if (!model.getPath().equals(ModelPath.ROOT)) {
            this.printNodeName(model, styledTextoutput);
            this.maybePrintType(model, styledTextoutput);
            this.maybePrintValue(model, styledTextoutput);
            this.printCreator(model, styledTextoutput);
            this.maybePrintRules(model, styledTextoutput);
        }
        if (model instanceof ModelReferenceNode) {
            return;
        }
        TreeMap<String, ModelNode> links = new TreeMap<String, ModelNode>();
        for (ModelNode modelNode : model.getLinks(ModelType.untyped())) {
            links.put(modelNode.getPath().getName(), modelNode);
        }
        output.collection(links.values(), this);
    }

    public void printNodeName(ModelNode model, StyledTextOutput styledTextoutput) {
        Optional<String> value = this.getNodeValue(model);
        boolean hasValue = value != null && value.isPresent();
        String intro = this.omitDetails() && model.getLinkCount() == 0 && hasValue ? "|" : "+";
        styledTextoutput.withStyle(StyledTextOutput.Style.Identifier).format("%s %s", intro, model.getPath().getName());
        if (this.omitDetails() && hasValue) {
            styledTextoutput.withStyle(StyledTextOutput.Style.Description).format(" = %s", value.get());
        }
        styledTextoutput.println();
    }

    private Optional<String> getNodeValue(ModelNode model) {
        if (model.getLinkCount() == 0 || model instanceof ModelReferenceNode) {
            return model.getValueDescription();
        }
        return null;
    }

    public void printCreator(ModelNode model, StyledTextOutput styledTextoutput) {
        if (this.omitDetails()) {
            return;
        }
        ModelRuleDescriptor descriptor = model.getDescriptor();
        StringBuffer buffer = new StringBuffer();
        descriptor.describeTo(buffer);
        this.printNodeAttribute(styledTextoutput, "Creator:", buffer.toString());
    }

    public void maybePrintType(ModelNode model, StyledTextOutput styledTextoutput) {
        if (this.omitDetails()) {
            return;
        }
        Optional<String> typeDescription = model.getTypeDescription();
        if (typeDescription.isPresent()) {
            this.printNodeAttribute(styledTextoutput, "Type:", (String)typeDescription.get());
        }
    }

    public void maybePrintValue(ModelNode model, StyledTextOutput styledTextoutput) {
        if (this.omitDetails()) {
            return;
        }
        Optional<String> value = this.getNodeValue(model);
        if (value != null && value.isPresent()) {
            this.printNodeAttribute(styledTextoutput, "Value:", (String)value.get());
        }
    }

    private void maybePrintRules(ModelNode model, StyledTextOutput styledTextoutput) {
        if (this.omitDetails()) {
            return;
        }
        Iterable<ModelRuleDescriptor> executedRules = ModelNodeRenderer.uniqueExecutedRulesExcludingCreator(model);
        if (!Iterables.isEmpty(executedRules)) {
            this.printNestedAttributeTitle(styledTextoutput, "Rules:");
            for (ModelRuleDescriptor ruleDescriptor : executedRules) {
                this.printNestedAttribute(styledTextoutput, "\u2937 " + ruleDescriptor.toString());
            }
        }
    }

    private void printNestedAttribute(StyledTextOutput styledTextoutput, String value) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Normal).format("         %s", value);
        styledTextoutput.println();
    }

    private void printNestedAttributeTitle(StyledTextOutput styledTextoutput, String title) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Identifier).format("      | %s", title);
        styledTextoutput.println();
    }

    public void printNodeAttribute(StyledTextOutput styledTextoutput, String label, String value) {
        styledTextoutput.withStyle(StyledTextOutput.Style.Identifier).format("      | %s", this.attributeLabel(label));
        styledTextoutput.withStyle(StyledTextOutput.Style.Description).format(" \t%s", value);
        styledTextoutput.println();
    }

    private String attributeLabel(String label) {
        return Strings.padEnd((String)label, (int)7, (char)' ');
    }

    static Iterable<ModelRuleDescriptor> uniqueExecutedRulesExcludingCreator(ModelNode model) {
        Iterable filtered = model.getExecutedRules().stream().filter(input -> !input.equals(model.getDescriptor())).collect(Collectors.toList());
        return ImmutableSet.copyOf((Iterable)filtered);
    }
}

