/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.VersionConflictException;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.internal.TextUtil;

class ResolutionErrorRenderer
implements Action<Throwable> {
    private final Spec<DependencyResult> dependencySpec;
    private final List<Action<StyledTextOutput>> errorActions = Lists.newArrayListWithExpectedSize((int)1);

    public ResolutionErrorRenderer(@Nullable Spec<DependencyResult> dependencySpec) {
        this.dependencySpec = dependencySpec;
    }

    @Override
    public void execute(Throwable throwable) {
        if (!(throwable instanceof ResolveException)) {
            throw UncheckedException.throwAsUncheckedException(throwable);
        }
        Throwable cause = throwable.getCause();
        this.handleResolutionError(cause);
    }

    private void handleResolutionError(Throwable cause) {
        if (cause instanceof VersionConflictException) {
            this.handleConflict((VersionConflictException)cause);
        } else if (cause instanceof LockOutOfDateException) {
            this.handleOutOfDateLocks((LockOutOfDateException)cause);
        } else {
            throw UncheckedException.throwAsUncheckedException(cause);
        }
    }

    private void handleOutOfDateLocks(LockOutOfDateException cause) {
        this.registerError(output -> {
            List<String> errors = cause.getErrors();
            output.text("The dependency locks are out-of-date:");
            output.println();
            for (String error : errors) {
                output.text("   - " + error);
                output.println();
            }
            output.println();
        });
    }

    private void handleConflict(VersionConflictException conflict) {
        this.registerError(output -> {
            Collection<Conflict> conflicts = conflict.getConflicts();
            String plural = TextUtil.getPluralEnding(conflicts);
            output.text("Dependency resolution failed because of conflict" + plural + " on the following module" + plural + ":");
            output.println();
            conflicts.stream().filter(idendifierStringPair -> this.hasVersionConflictOnRequestedDependency(idendifierStringPair.getVersions())).forEach(identifierStringPair -> {
                output.text("   - ");
                output.withStyle(StyledTextOutput.Style.Error).text(identifierStringPair.getMessage());
                output.println();
            });
            output.println();
        });
    }

    public void renderErrors(StyledTextOutput output) {
        for (Action<StyledTextOutput> errorAction : this.errorActions) {
            errorAction.execute(output);
        }
    }

    private void registerError(Action<StyledTextOutput> errorAction) {
        this.errorActions.add(errorAction);
    }

    private boolean hasVersionConflictOnRequestedDependency(Collection<? extends ModuleVersionIdentifier> versionIdentifiers) {
        Objects.requireNonNull(this.dependencySpec, "Dependency spec must be specified");
        for (ModuleVersionIdentifier moduleVersionIdentifier : versionIdentifiers) {
            if (!this.dependencySpec.isSatisfiedBy(this.asDependencyResult(moduleVersionIdentifier))) continue;
            return true;
        }
        return false;
    }

    private DependencyResult asDependencyResult(final ModuleVersionIdentifier versionIdentifier) {
        return new DependencyResult(){

            @Override
            public ComponentSelector getRequested() {
                return DefaultModuleComponentSelector.newSelector(versionIdentifier.getModule(), versionIdentifier.getVersion());
            }

            @Override
            public ResolvedComponentResult getFrom() {
                return null;
            }

            @Override
            public boolean isConstraint() {
                return false;
            }
        };
    }
}

