/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.local.internal;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.BuildCacheServiceFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.H2BuildCacheService;
import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.file.PathToFileResolver;

public class H2BuildCacheServiceFactory
implements BuildCacheServiceFactory<DirectoryBuildCache> {
    private static final String BUILD_CACHE_VERSION = "2";
    private static final String BUILD_CACHE_KEY = "build-cache-2";
    private static final String H2_BUILD_CACHE_TYPE = "h2";
    private final GlobalScopedCacheBuilderFactory cacheBuilderFactory;
    private final ParallelismConfiguration parallelismConfiguration;
    private final PathToFileResolver resolver;

    @Inject
    public H2BuildCacheServiceFactory(GlobalScopedCacheBuilderFactory cacheBuilderFactory, ParallelismConfiguration parallelismConfiguration, PathToFileResolver resolver) {
        this.cacheBuilderFactory = cacheBuilderFactory;
        this.parallelismConfiguration = parallelismConfiguration;
        this.resolver = resolver;
    }

    @Override
    public BuildCacheService createBuildCacheService(DirectoryBuildCache configuration, BuildCacheServiceFactory.Describer describer) {
        Object cacheDirectory = configuration.getDirectory();
        File target = cacheDirectory != null ? this.resolver.resolve(cacheDirectory) : this.cacheBuilderFactory.baseDirForCrossVersionCache(BUILD_CACHE_KEY);
        H2BuildCacheServiceFactory.checkDirectory(target);
        int removeUnusedEntriesAfterDays = configuration.getRemoveUnusedEntriesAfterDays();
        describer.type(H2_BUILD_CACHE_TYPE).config("location", target.getAbsolutePath());
        return new H2BuildCacheService(target.toPath(), this.parallelismConfiguration.getMaxWorkerCount());
    }

    private static void checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
    }
}

