/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.internal;

import java.util.List;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.gradle.configuration.internal.DynamicCallContextTracker;

public class DefaultDynamicCallContextTracker
implements DynamicCallContextTracker {
    private final ThreadLocal<State> stateByThread = ThreadLocal.withInitial(() -> new State());
    private final List<Consumer<Object>> enterListeners = new CopyOnWriteArrayList<Consumer<Object>>();
    private final List<Consumer<Object>> leaveListeners = new CopyOnWriteArrayList<Consumer<Object>>();

    @Override
    public void enterDynamicCall(@Nonnull Object entryPoint) {
        this.currentEntryPointStack().push(entryPoint);
        this.enterListeners.forEach(listener2 -> listener2.accept(entryPoint));
    }

    @Override
    public void leaveDynamicCall(@Nonnull Object entryPoint) {
        Stack<Object> entryPointsStack = this.currentEntryPointStack();
        Object top = entryPointsStack.peek();
        if (top != entryPoint) {
            throw new IllegalStateException("Mismatch in leaving dynamic call: leaving " + entryPoint + ", while " + top + " should be left.");
        }
        entryPointsStack.pop();
        this.leaveListeners.forEach(listener2 -> listener2.accept(entryPoint));
    }

    @Override
    public void onEnter(Consumer<Object> listener2) {
        this.enterListeners.add(listener2);
    }

    @Override
    public void onLeave(Consumer<Object> listener2) {
        this.leaveListeners.add(listener2);
    }

    private Stack<Object> currentEntryPointStack() {
        return this.stateByThread.get().entryPointsStack;
    }

    private static class State {
        Stack<Object> entryPointsStack = new Stack();

        private State() {
        }
    }
}

