/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.Binding;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.io.PrintStream;
import java.util.Map;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.project.DynamicLookupRoutine;
import org.gradle.groovy.scripts.Script;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.metaobject.DynamicObjectUtil;
import org.gradle.internal.scripts.GradleScript;
import org.gradle.internal.service.ServiceRegistry;

public abstract class BasicScript
extends Script
implements org.gradle.api.Script,
DynamicObjectAware,
GradleScript {
    private StandardOutputCapture standardOutputCapture;
    private Object target;
    private final ScriptDynamicObject dynamicObject = new ScriptDynamicObject(this);
    private DynamicLookupRoutine dynamicLookupRoutine;

    @Override
    public void init(Object target, ServiceRegistry services) {
        this.standardOutputCapture = services.get(StandardOutputCapture.class);
        this.dynamicLookupRoutine = services.get(DynamicLookupRoutine.class);
        this.setScriptTarget(target);
    }

    public Object getScriptTarget() {
        return this.target;
    }

    private void setScriptTarget(Object target) {
        this.target = target;
        this.dynamicObject.setTarget(target);
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.standardOutputCapture;
    }

    public PrintStream getOut() {
        return System.out;
    }

    public Object getProperty(String property2) {
        return this.dynamicLookupRoutine.property(this.dynamicObject, property2);
    }

    public void setProperty(String property2, Object newValue) {
        this.dynamicLookupRoutine.setProperty(this.dynamicObject, property2, newValue);
    }

    public Map<String, ?> getProperties() {
        return this.dynamicLookupRoutine.getProperties(this.dynamicObject);
    }

    public boolean hasProperty(String property2) {
        return this.dynamicLookupRoutine.hasProperty(this.dynamicObject, property2);
    }

    public Object invokeMethod(String name, Object args) {
        return this.dynamicLookupRoutine.invokeMethod(this.dynamicObject, name, (Object[])args);
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.dynamicObject;
    }

    private static final class ScriptDynamicObject
    extends AbstractDynamicObject {
        private final Binding binding;
        private final DynamicObject scriptObject;
        private DynamicObject dynamicTarget;

        ScriptDynamicObject(BasicScript script) {
            this.binding = script.getBinding();
            this.dynamicTarget = this.scriptObject = new BeanDynamicObject(script).withNotImplementsMissing();
        }

        public void setTarget(Object target) {
            this.dynamicTarget = DynamicObjectUtil.asDynamicObject(target);
        }

        @Override
        public Map<String, ?> getProperties() {
            return this.dynamicTarget.getProperties();
        }

        @Override
        public boolean hasMethod(String name, Object ... arguments) {
            return this.scriptObject.hasMethod(name, arguments) || this.dynamicTarget.hasMethod(name, arguments);
        }

        @Override
        public boolean hasProperty(String name) {
            return this.binding.hasVariable(name) || this.scriptObject.hasProperty(name) || this.dynamicTarget.hasProperty(name);
        }

        @Override
        public DynamicInvokeResult tryInvokeMethod(String name, Object ... arguments) {
            DynamicInvokeResult result2 = this.scriptObject.tryInvokeMethod(name, arguments);
            if (result2.isFound()) {
                return result2;
            }
            return this.dynamicTarget.tryInvokeMethod(name, arguments);
        }

        @Override
        public DynamicInvokeResult tryGetProperty(String property2) {
            if (this.binding.hasVariable(property2)) {
                return DynamicInvokeResult.found(this.binding.getVariable(property2));
            }
            DynamicInvokeResult result2 = this.scriptObject.tryGetProperty(property2);
            if (result2.isFound()) {
                return result2;
            }
            return this.dynamicTarget.tryGetProperty(property2);
        }

        @Override
        public DynamicInvokeResult trySetProperty(String property2, Object newValue) {
            return this.dynamicTarget.trySetProperty(property2, newValue);
        }

        @Override
        public MissingPropertyException getMissingProperty(String name) {
            return this.dynamicTarget.getMissingProperty(name);
        }

        @Override
        public MissingMethodException methodMissingException(String name, Object ... params) {
            return this.dynamicTarget.methodMissingException(name, params);
        }

        @Override
        public MissingPropertyException setMissingProperty(String name) {
            return this.dynamicTarget.setMissingProperty(name);
        }

        @Override
        public String getDisplayName() {
            return this.dynamicTarget.toString();
        }
    }
}

