/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.initialization.ClassLoaderRegistry;
import org.gradle.internal.classloader.ConfigurableClassLoaderHierarchyHasher;
import org.gradle.internal.classloader.HashingClassLoaderFactory;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.GradleVersion;

public class RegistryAwareClassLoaderHierarchyHasher
extends ConfigurableClassLoaderHierarchyHasher {
    public RegistryAwareClassLoaderHierarchyHasher(ClassLoaderRegistry registry, HashingClassLoaderFactory classLoaderFactory) {
        super(RegistryAwareClassLoaderHierarchyHasher.collectKnownClassLoaders(registry), classLoaderFactory);
    }

    private static Map<ClassLoader, String> collectKnownClassLoaders(ClassLoaderRegistry registry) {
        HashMap knownClassLoaders = Maps.newHashMap();
        String gradleVersion = GradleVersion.current().getVersion();
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, null, "bootstrap");
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getRuntimeClassLoader(), "runtime:" + gradleVersion);
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getGradleApiClassLoader(), "gradle-api:" + gradleVersion);
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getGradleCoreApiClassLoader(), "gradle-core-api:" + gradleVersion);
        RegistryAwareClassLoaderHierarchyHasher.addClassLoader(knownClassLoaders, registry.getPluginsClassLoader(), "plugins:" + gradleVersion);
        return knownClassLoaders;
    }

    private static void addClassLoader(Map<ClassLoader, String> knownClassLoaders, @Nullable ClassLoader classLoader, String id) {
        knownClassLoaders.put(classLoader, id);
    }
}

