/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.Nullable;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.archive.ZipEntry;
import org.gradle.api.internal.file.archive.ZipInput;
import org.gradle.api.internal.file.archive.impl.FileZipInput;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Pair;
import org.gradle.internal.classpath.CachedClasspathTransformer;
import org.gradle.internal.classpath.ClassData;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.ClasspathEntryVisitor;
import org.gradle.internal.classpath.ClasspathFileTransformer;
import org.gradle.internal.classpath.ClasspathWalker;
import org.gradle.internal.file.FileException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassWriter;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.util.internal.GFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstrumentingClasspathFileTransformer
implements ClasspathFileTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstrumentingClasspathFileTransformer.class);
    private static final int CACHE_FORMAT = 5;
    private static final int AGENT_INSTRUMENTATION_VERSION = 2;
    private static final String MULTI_RELEASE_ATTRIBUTE = "Multi-Release";
    private final FileLockManager fileLockManager;
    private final ClasspathWalker classpathWalker;
    private final ClasspathBuilder classpathBuilder;
    private final Policy policy;
    private final CachedClasspathTransformer.Transform transform;
    private final HashCode configHash;

    public InstrumentingClasspathFileTransformer(FileLockManager fileLockManager, ClasspathWalker classpathWalker, ClasspathBuilder classpathBuilder, Policy policy, CachedClasspathTransformer.Transform transform) {
        this.fileLockManager = fileLockManager;
        this.classpathWalker = classpathWalker;
        this.classpathBuilder = classpathBuilder;
        this.policy = policy;
        this.transform = transform;
        this.configHash = this.configHashFor(transform);
    }

    private HashCode configHashFor(CachedClasspathTransformer.Transform transform) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putInt(5);
        this.policy.applyConfigurationTo(hasher);
        transform.applyConfigurationTo(hasher);
        return hasher.hash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File transform(File source, FileSystemLocationSnapshot sourceSnapshot, File cacheDir) {
        String destDirName = this.hashOf(sourceSnapshot);
        File destDir = new File(cacheDir, destDirName);
        String destFileName = sourceSnapshot.getType() == FileType.Directory ? source.getName() + ".jar" : source.getName();
        File receipt = new File(destDir, destFileName + ".receipt");
        File transformed = new File(destDir, destFileName);
        if (receipt.isFile()) {
            return transformed;
        }
        File lockFile = new File(destDir, destFileName + ".lock");
        try (FileLock fileLock = this.exclusiveLockFor(lockFile);){
            if (receipt.isFile()) {
                File file = transformed;
                return file;
            }
            this.transform(source, transformed);
            try {
                receipt.createNewFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(String.format("Failed to create receipt for instrumented classpath file '%s/%s'.", destDirName, destFileName), e);
            }
            File file = transformed;
            return file;
        }
    }

    private FileLock exclusiveLockFor(File file) {
        return this.fileLockManager.lock(file, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive).useCrossVersionImplementation(), "instrumented jar cache");
    }

    private String hashOf(FileSystemLocationSnapshot sourceSnapshot) {
        Hasher hasher = Hashing.defaultFunction().newHasher();
        hasher.putHash(this.configHash);
        hasher.putHash(sourceSnapshot.getHash());
        return hasher.hash().toString();
    }

    private void transform(File source, File dest) {
        if (this.policy.instrumentFile(source)) {
            this.instrument(source, dest);
        } else {
            LOGGER.debug("Signed archive '{}'. Skipping instrumentation.", (Object)source.getName());
            GFileUtils.copyFile(source, dest);
        }
    }

    private void instrument(File source, File dest) {
        this.classpathBuilder.jar(dest, builder -> {
            try {
                this.visitEntries(source, builder);
            }
            catch (FileException e) {
                LOGGER.debug("Malformed archive '{}'. Discarding contents.", (Object)source.getName(), (Object)e);
            }
        });
    }

    private void visitEntries(File source, ClasspathBuilder.EntryBuilder builder) throws IOException, FileException {
        this.classpathWalker.visit(source, entry -> {
            try {
                if (!this.policy.includeEntry(entry)) {
                    return;
                }
                if (InstrumentingClasspathFileTransformer.isClassFile(entry)) {
                    ClassReader reader2 = new ClassReader(entry.getContent());
                    ClassWriter classWriter = new ClassWriter(1);
                    Pair<RelativePath, ClassVisitor> chain = this.transform.apply(entry, (ClassVisitor)classWriter, new ClassData(reader2));
                    reader2.accept((ClassVisitor)chain.right, 0);
                    byte[] bytes = classWriter.toByteArray();
                    builder.put(((RelativePath)chain.left).getPathString(), bytes, entry.getCompressionMethod());
                } else if (InstrumentingClasspathFileTransformer.isManifest(entry)) {
                    byte[] processedManifest = this.policy.processManifest(source, entry);
                    if (processedManifest != null) {
                        builder.put(entry.getName(), processedManifest, entry.getCompressionMethod());
                    }
                } else {
                    builder.put(entry.getName(), entry.getContent(), entry.getCompressionMethod());
                }
            }
            catch (Throwable e) {
                throw new IOException("Failed to process the entry '" + entry.getName() + "' from '" + source + "'", e);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isSignedJar(File source) {
        if (!source.isFile()) {
            return false;
        }
        try (ZipInput entries2 = FileZipInput.create(source);){
            ZipEntry entry;
            String entryName;
            Iterator iterator = entries2.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(entryName = (entry = (ZipEntry)iterator.next()).getName()).startsWith("META-INF/") || !entryName.endsWith(".SF"));
            boolean bl = true;
            return bl;
        }
        catch (FileException entries2) {
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Policy instrumentForLoadingWithClassLoader() {
        return new Policy(){

            @Override
            public void applyConfigurationTo(Hasher hasher) {
            }

            @Override
            public boolean instrumentFile(File file) {
                return !InstrumentingClasspathFileTransformer.isSignedJar(file);
            }

            @Override
            public byte[] processManifest(File source, ClasspathEntryVisitor.Entry entry) throws IOException {
                return entry.getContent();
            }

            @Override
            public boolean includeEntry(ClasspathEntryVisitor.Entry entry) {
                return true;
            }
        };
    }

    public static Policy instrumentForLoadingWithAgent() {
        return new Policy(){

            @Override
            public void applyConfigurationTo(Hasher hasher) {
                hasher.putInt(2);
            }

            @Override
            public boolean instrumentFile(File file) {
                return true;
            }

            @Override
            public byte[] processManifest(File source, ClasspathEntryVisitor.Entry entry) throws IOException {
                try {
                    Manifest parsedManifest = new Manifest(new ByteArrayInputStream(entry.getContent()));
                    if (this.isMultiReleaseJarManifest(parsedManifest)) {
                        Manifest processedManifest = new Manifest();
                        this.copyManifestMainAttribute(parsedManifest, processedManifest, Attributes.Name.MANIFEST_VERSION);
                        this.setManifestMainAttribute(processedManifest, InstrumentingClasspathFileTransformer.MULTI_RELEASE_ATTRIBUTE, "true");
                        return this.toByteArray(processedManifest);
                    }
                    return null;
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to parse Manifest from JAR " + source);
                    throw e;
                }
            }

            @Nullable
            private String getManifestMainAttribute(Manifest manifest, String name) {
                return manifest.getMainAttributes().getValue(name);
            }

            private void copyManifestMainAttribute(Manifest source, Manifest destination, Attributes.Name name) {
                destination.getMainAttributes().put(name, source.getMainAttributes().getValue(name));
            }

            private void setManifestMainAttribute(Manifest manifest, String name, String value) {
                manifest.getMainAttributes().putValue(name, value);
            }

            private boolean isMultiReleaseJarManifest(Manifest manifest) {
                return Boolean.parseBoolean(this.getManifestMainAttribute(manifest, InstrumentingClasspathFileTransformer.MULTI_RELEASE_ATTRIBUTE));
            }

            private byte[] toByteArray(Manifest manifest) throws IOException {
                ByteArrayOutputStream manifestOutput = new ByteArrayOutputStream(512);
                manifest.write(manifestOutput);
                return manifestOutput.toByteArray();
            }

            @Override
            public boolean includeEntry(ClasspathEntryVisitor.Entry entry) {
                return InstrumentingClasspathFileTransformer.isClassFile(entry) || InstrumentingClasspathFileTransformer.isManifest(entry);
            }
        };
    }

    private static boolean isClassFile(ClasspathEntryVisitor.Entry entry) {
        return entry.getName().endsWith(".class");
    }

    private static boolean isManifest(ClasspathEntryVisitor.Entry entry) {
        return entry.getName().equals("META-INF/MANIFEST.MF");
    }

    public static interface Policy {
        public void applyConfigurationTo(Hasher var1);

        public boolean instrumentFile(File var1);

        @Nullable
        public byte[] processManifest(File var1, ClasspathEntryVisitor.Entry var2) throws IOException;

        public boolean includeEntry(ClasspathEntryVisitor.Entry var1);
    }
}

