/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.Path;

public class DefaultProjectComponentSelector
implements ProjectComponentSelector {
    private final BuildIdentifier buildIdentifier;
    private final Path projectPath;
    private final Path identityPath;
    private final String projectName;
    private final ImmutableAttributes attributes;
    private final List<Capability> requestedCapabilities;
    private String displayName;

    public DefaultProjectComponentSelector(BuildIdentifier buildIdentifier, Path identityPath, Path projectPath, String projectName, ImmutableAttributes attributes, List<Capability> requestedCapabilities) {
        assert (buildIdentifier != null) : "build cannot be null";
        assert (identityPath != null) : "identity path cannot be null";
        assert (projectPath != null) : "project path cannot be null";
        assert (projectName != null) : "project name cannot be null";
        assert (attributes != null) : "attributes cannot be null";
        assert (requestedCapabilities != null) : "capabilities cannot be null";
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.projectPath = projectPath;
        this.projectName = projectName;
        this.attributes = attributes;
        this.requestedCapabilities = requestedCapabilities;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = "project " + this.identityPath;
        }
        return this.displayName;
    }

    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public String getBuildPath() {
        return this.buildIdentifier.getBuildPath();
    }

    @Override
    public String getBuildName() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ProjectComponentSelector.class, "getBuildName()").withAdvice("Use getBuildPath() to get a unique identifier for the build.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "build_identifier_name_and_current_deprecation")).nagUser();
        return DeprecationLogger.whileDisabled(this.buildIdentifier::getName);
    }

    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public String getProjectPath() {
        return this.projectPath.getPath();
    }

    public Path projectPath() {
        return this.projectPath;
    }

    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof DefaultProjectComponentIdentifier) {
            DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
            return projectComponentIdentifier.getIdentityPath().equals(this.identityPath);
        }
        return false;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Capability> getRequestedCapabilities() {
        return this.requestedCapabilities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProjectComponentSelector)) {
            return false;
        }
        DefaultProjectComponentSelector that = (DefaultProjectComponentSelector)o;
        if (!this.identityPath.equals(that.identityPath)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        return this.requestedCapabilities.equals(that.requestedCapabilities);
    }

    public int hashCode() {
        return this.identityPath.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ProjectComponentSelector newSelector(Project project) {
        return DefaultProjectComponentSelector.newSelector(project, ImmutableAttributes.EMPTY, Collections.emptyList());
    }

    public static ProjectComponentSelector newSelector(Project project, ImmutableAttributes attributes, List<Capability> requestedCapabilities) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        ProjectComponentIdentifier projectComponentIdentifier = projectInternal.getOwner().getComponentIdentifier();
        return new DefaultProjectComponentSelector(projectComponentIdentifier.getBuild(), projectInternal.getIdentityPath(), projectInternal.getProjectPath(), project.getName(), attributes, requestedCapabilities);
    }

    public static ProjectComponentSelector newSelector(ProjectComponentIdentifier identifier) {
        DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
        return new DefaultProjectComponentSelector(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getIdentityPath(), projectComponentIdentifier.projectPath(), projectComponentIdentifier.getProjectName(), ImmutableAttributes.EMPTY, Collections.emptyList());
    }

    public static ProjectComponentSelector newSelector(ProjectComponentIdentifier identifier, ImmutableAttributes attributes, List<Capability> requestedCapabilities) {
        DefaultProjectComponentIdentifier projectComponentIdentifier = (DefaultProjectComponentIdentifier)identifier;
        return new DefaultProjectComponentSelector(projectComponentIdentifier.getBuild(), projectComponentIdentifier.getIdentityPath(), projectComponentIdentifier.projectPath(), projectComponentIdentifier.getProjectName(), attributes, requestedCapabilities);
    }

    public static ProjectComponentSelector withAttributes(ProjectComponentSelector selector, ImmutableAttributes attributes) {
        DefaultProjectComponentSelector current = (DefaultProjectComponentSelector)selector;
        return new DefaultProjectComponentSelector(current.buildIdentifier, current.identityPath, current.projectPath, current.projectName, attributes, current.requestedCapabilities);
    }

    public static ComponentSelector withCapabilities(ProjectComponentSelector selector, List<Capability> requestedCapabilities) {
        DefaultProjectComponentSelector current = (DefaultProjectComponentSelector)selector;
        return new DefaultProjectComponentSelector(current.buildIdentifier, current.identityPath, current.projectPath, current.projectName, current.attributes, requestedCapabilities);
    }

    public ProjectComponentIdentifier toIdentifier() {
        return new DefaultProjectComponentIdentifier(this.buildIdentifier, this.identityPath, this.projectPath, this.projectName);
    }
}

