/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultVariantMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public final class LocalVariantMetadata
extends DefaultVariantMetadata {
    private final CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts;

    public LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, ComponentIdentifier componentId, DisplayName displayName, ImmutableAttributes attributes, Collection<? extends PublishArtifact> sourceArtifacts, ImmutableCapabilities capabilities, ModelContainer<?> model, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this(name, identifier, displayName, attributes, capabilities, calculatedValueContainerFactory.create(Describables.of(displayName, "artifacts"), context -> {
            if (sourceArtifacts.isEmpty()) {
                return ImmutableList.of();
            }
            return model.fromMutableState(m -> {
                ImmutableList.Builder result2 = ImmutableList.builderWithExpectedSize((int)sourceArtifacts.size());
                for (PublishArtifact sourceArtifact : sourceArtifacts) {
                    result2.add((Object)new PublishArtifactLocalArtifactMetadata(componentId, sourceArtifact));
                }
                return result2.build();
            });
        }));
    }

    public LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, List<LocalComponentArtifactMetadata> artifacts2, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this(name, identifier, displayName, attributes, capabilities, calculatedValueContainerFactory.create(Describables.of(displayName, "artifacts"), ImmutableList.copyOf(artifacts2)));
    }

    private LocalVariantMetadata(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts2) {
        super(name, identifier, displayName, attributes, (ImmutableList<? extends ComponentArtifactMetadata>)ImmutableList.of(), capabilities);
        this.artifacts = artifacts2;
    }

    public LocalVariantMetadata prepareToResolveArtifacts() {
        this.artifacts.finalizeIfNotAlready();
        return this;
    }

    @Override
    public boolean isEligibleForCaching() {
        return true;
    }

    public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
        return this.artifacts.get();
    }
}

