/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import java.lang.annotation.Annotation;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.internal.execution.model.InputNormalizer;
import org.gradle.internal.execution.model.annotations.AbstractInputPropertyAnnotationHandler;
import org.gradle.internal.execution.model.annotations.ModifierAnnotationCategory;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.properties.InputFilePropertyType;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.work.Incremental;
import org.gradle.work.NormalizeLineEndings;

public abstract class AbstractInputFilePropertyAnnotationHandler
extends AbstractInputPropertyAnnotationHandler {
    private final InputFilePropertyType filePropertyType;

    public AbstractInputFilePropertyAnnotationHandler(Class<? extends Annotation> annotationType, InputFilePropertyType filePropertyType, ImmutableSet<Class<? extends Annotation>> allowedModifiers) {
        super(annotationType, allowedModifiers);
        this.filePropertyType = filePropertyType;
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
        FileNormalizer normalizer = propertyMetadata.getAnnotationForCategory(ModifierAnnotationCategory.NORMALIZATION).map(fileNormalization -> {
            if (fileNormalization instanceof PathSensitive) {
                PathSensitivity pathSensitivity = ((PathSensitive)fileNormalization).value();
                return InputNormalizer.determineNormalizerForPathSensitivity(pathSensitivity);
            }
            if (fileNormalization instanceof Classpath) {
                return InputNormalizer.RUNTIME_CLASSPATH;
            }
            if (fileNormalization instanceof CompileClasspath) {
                return InputNormalizer.COMPILE_CLASSPATH;
            }
            throw new IllegalStateException("Unknown normalization annotation used: " + fileNormalization);
        }).orElse(null);
        visitor.visitInputFileProperty(propertyName, propertyMetadata.isAnnotationPresent(Optional.class), AbstractInputFilePropertyAnnotationHandler.determineBehavior(propertyMetadata), this.determineDirectorySensitivity(propertyMetadata), AbstractInputFilePropertyAnnotationHandler.determineLineEndingSensitivity(propertyMetadata), normalizer, value, this.filePropertyType);
    }

    private static InputBehavior determineBehavior(PropertyMetadata propertyMetadata) {
        return propertyMetadata.isAnnotationPresent(SkipWhenEmpty.class) ? InputBehavior.PRIMARY : (propertyMetadata.isAnnotationPresent(Incremental.class) ? InputBehavior.INCREMENTAL : InputBehavior.NON_INCREMENTAL);
    }

    private static LineEndingSensitivity determineLineEndingSensitivity(PropertyMetadata propertyMetadata) {
        return propertyMetadata.isAnnotationPresent(NormalizeLineEndings.class) ? LineEndingSensitivity.NORMALIZE_LINE_ENDINGS : LineEndingSensitivity.DEFAULT;
    }

    protected DirectorySensitivity determineDirectorySensitivity(PropertyMetadata propertyMetadata) {
        return propertyMetadata.isAnnotationPresent(IgnoreEmptyDirectories.class) ? DirectorySensitivity.IGNORE_DIRECTORIES : DirectorySensitivity.DEFAULT;
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        AbstractInputFilePropertyAnnotationHandler.validateUnsupportedInputPropertyValueTypes(propertyMetadata, validationContext, this.getAnnotationType());
        if (!propertyMetadata.hasAnnotationForCategory(ModifierAnnotationCategory.NORMALIZATION)) {
            validationContext.visitPropertyProblem(problem2 -> {
                String propertyName = propertyMetadata.getPropertyName();
                ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.MISSING_NORMALIZATION_ANNOTATION)).reportAs(Severity.ERROR)).onlyAffectsCacheableWork()).forProperty(propertyName).withDescription(() -> String.format("is annotated with @%s but missing a normalization strategy", this.getAnnotationType().getSimpleName()))).happensBecause("If you don't declare the normalization, outputs can't be re-used between machines or locations on the same machine, therefore caching efficiency drops significantly")).addPossibleSolution("Declare the normalization strategy by annotating the property with either @PathSensitive, @Classpath or @CompileClasspath")).documentedAt("validation_problems", "missing_normalization_annotation");
            });
        }
    }
}

