/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.util.internal.GUtil;

public class CachingDirectedGraphWalker<N, T> {
    private final DirectedGraphWithEdgeValues<N, T> graph;
    private List<N> startNodes = new ArrayList<N>();
    private Set<NodeDetails<N, T>> strongComponents = new LinkedHashSet<NodeDetails<N, T>>();
    private final Map<N, Set<T>> cachedNodeValues = new HashMap<N, Set<T>>();

    public CachingDirectedGraphWalker(DirectedGraph<N, T> graph) {
        this.graph = new GraphWithEmptyEdges<N, T>(graph);
    }

    public CachingDirectedGraphWalker(DirectedGraphWithEdgeValues<N, T> graph) {
        this.graph = graph;
    }

    public CachingDirectedGraphWalker<N, T> add(N ... values) {
        this.add((Iterable<? extends N>)Arrays.asList(values));
        return this;
    }

    public CachingDirectedGraphWalker<?, ?> add(Iterable<? extends N> values) {
        GUtil.addToCollection(this.startNodes, values);
        return this;
    }

    public Set<T> findValues() {
        try {
            Set<T> set2 = this.doSearch();
            return set2;
        }
        finally {
            this.startNodes.clear();
        }
    }

    public List<Set<N>> findCycles() {
        this.findValues();
        ArrayList<Set<N>> result2 = new ArrayList<Set<N>>();
        for (NodeDetails<N, T> nodeDetails : this.strongComponents) {
            LinkedHashSet<Object> componentMembers = new LinkedHashSet<Object>();
            for (NodeDetails componentMember : ((NodeDetails)nodeDetails).componentMembers) {
                componentMembers.add(componentMember.node);
            }
            result2.add(componentMembers);
        }
        return result2;
    }

    private Set<T> doSearch() {
        int componentCount = 0;
        HashMap seenNodes = new HashMap();
        HashMap components = new HashMap();
        ArrayDeque<N> queue = new ArrayDeque<N>(this.startNodes);
        while (!queue.isEmpty()) {
            Object node = queue.getFirst();
            NodeDetails details = (NodeDetails)seenNodes.get(node);
            if (details == null) {
                details = new NodeDetails(node, componentCount++);
                seenNodes.put(node, details);
                components.put(details.component, details);
                Set<T> cacheValues = this.cachedNodeValues.get(node);
                if (cacheValues != null) {
                    details.values = cacheValues;
                    details.finished = true;
                    queue.removeFirst();
                    continue;
                }
                this.graph.getNodeValues(node, details.values, details.successors);
                for (Object connectedNode : details.successors) {
                    NodeDetails connectedNodeDetails = (NodeDetails)seenNodes.get(connectedNode);
                    if (connectedNodeDetails == null) {
                        queue.addFirst(connectedNode);
                        continue;
                    }
                    if (connectedNodeDetails.finished) continue;
                    details.stronglyConnected = true;
                }
                continue;
            }
            queue.removeFirst();
            if (this.cachedNodeValues.containsKey(node)) continue;
            for (Object connectedNode : details.successors) {
                NodeDetails connectedNodeDetails = (NodeDetails)seenNodes.get(connectedNode);
                if (!connectedNodeDetails.finished) {
                    int minSeen = Math.min(details.minSeen, connectedNodeDetails.minSeen);
                    details.minSeen = minSeen;
                    connectedNodeDetails.minSeen = minSeen;
                    details.stronglyConnected = true;
                }
                details.values.addAll(connectedNodeDetails.values);
                this.graph.getEdgeValues(node, connectedNode, details.values);
            }
            if (details.minSeen != details.component) {
                NodeDetails rootDetails = (NodeDetails)components.get(details.minSeen);
                rootDetails.values.addAll(details.values);
                details.values.clear();
                rootDetails.componentMembers.addAll(details.componentMembers);
                continue;
            }
            for (NodeDetails componentMember : details.componentMembers) {
                this.cachedNodeValues.put(componentMember.node, details.values);
                componentMember.finished = true;
                components.remove(componentMember.component);
            }
            if (!details.stronglyConnected) continue;
            this.strongComponents.add(details);
        }
        LinkedHashSet values = new LinkedHashSet();
        for (N startNode : this.startNodes) {
            values.addAll(this.cachedNodeValues.get(startNode));
        }
        return values;
    }

    private static class GraphWithEmptyEdges<N, T>
    implements DirectedGraphWithEdgeValues<N, T> {
        private final DirectedGraph<N, T> graph;

        public GraphWithEmptyEdges(DirectedGraph<N, T> graph) {
            this.graph = graph;
        }

        @Override
        public void getEdgeValues(N from, N to, Collection<T> values) {
        }

        @Override
        public void getNodeValues(N node, Collection<? super T> values, Collection<? super N> connectedNodes) {
            this.graph.getNodeValues((N)node, (Collection<T>)values, connectedNodes);
        }
    }

    private static class NodeDetails<N, T> {
        private final int component;
        private final N node;
        private Set<T> values = new LinkedHashSet<T>();
        private List<N> successors = new ArrayList<N>();
        private Set<NodeDetails<N, T>> componentMembers = new LinkedHashSet<NodeDetails<N, T>>();
        private int minSeen;
        private boolean stronglyConnected;
        private boolean finished;

        public NodeDetails(N node, int component) {
            this.node = node;
            this.component = component;
            this.minSeen = component;
            this.componentMembers.add(this);
        }
    }
}

