/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.nativeintegration.filesystem.FileMetadataAccessor;

public class FallbackFileMetadataAccessor
implements FileMetadataAccessor {
    @Override
    public FileMetadata stat(File f) {
        if (!f.exists()) {
            return DefaultFileMetadata.missing(FileMetadata.AccessType.DIRECT);
        }
        if (f.isDirectory()) {
            return DefaultFileMetadata.directory(FileMetadata.AccessType.DIRECT);
        }
        if (f.isFile()) {
            return DefaultFileMetadata.file(f.lastModified(), f.length(), FileMetadata.AccessType.DIRECT);
        }
        throw new UncheckedIOException("Unsupported file type for " + f.getAbsolutePath());
    }
}

