/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.reflect.TypeToken;
import org.gradle.internal.properties.annotations.PropertyAnnotationHandler;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.properties.annotations.PropertyTypeResolver;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.properties.annotations.TypeMetadata;
import org.gradle.internal.properties.annotations.TypeMetadataStore;
import org.gradle.internal.reflect.annotations.AnnotationCategory;
import org.gradle.internal.reflect.annotations.PropertyAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadata;
import org.gradle.internal.reflect.annotations.TypeAnnotationMetadataStore;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.PropertyProblemBuilder;
import org.gradle.internal.reflect.validation.ReplayingTypeValidationContext;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class DefaultTypeMetadataStore
implements TypeMetadataStore {
    private final Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers;
    private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> propertyAnnotationHandlers;
    private final ImmutableSet<Class<? extends Annotation>> allowedPropertyModifiers;
    private final CrossBuildInMemoryCache<Class<?>, TypeMetadata> cache;
    private final TypeAnnotationMetadataStore typeAnnotationMetadataStore;
    private final PropertyTypeResolver propertyTypeResolver;
    private final String displayName;

    public DefaultTypeMetadataStore(Collection<? extends TypeAnnotationHandler> typeAnnotationHandlers, Collection<? extends PropertyAnnotationHandler> propertyAnnotationHandlers, Collection<Class<? extends Annotation>> allowedPropertyModifiers, TypeAnnotationMetadataStore typeAnnotationMetadataStore, PropertyTypeResolver propertyTypeResolver, CrossBuildInMemoryCacheFactory cacheFactory) {
        this.typeAnnotationHandlers = ImmutableSet.copyOf(typeAnnotationHandlers);
        this.propertyAnnotationHandlers = Maps.uniqueIndex(propertyAnnotationHandlers, PropertyAnnotationHandler::getAnnotationType);
        this.allowedPropertyModifiers = ImmutableSet.copyOf(allowedPropertyModifiers);
        this.typeAnnotationMetadataStore = typeAnnotationMetadataStore;
        this.displayName = DefaultTypeMetadataStore.calculateDisplayName(propertyAnnotationHandlers);
        this.propertyTypeResolver = propertyTypeResolver;
        this.cache = cacheFactory.newClassCache();
    }

    private static String calculateDisplayName(Collection<? extends PropertyAnnotationHandler> annotationHandlers) {
        return annotationHandlers.stream().map(PropertyAnnotationHandler::getKind).anyMatch(Predicate.isEqual((Object)PropertyAnnotationHandler.Kind.OUTPUT)) ? "an input or output annotation" : "an input annotation";
    }

    @Override
    public <T> TypeMetadata getTypeMetadata(Class<T> type) {
        return this.cache.get(type, this::createTypeMetadata);
    }

    private <T> TypeMetadata createTypeMetadata(Class<T> type) {
        Class<?> publicType = GeneratedSubclasses.unpack(type);
        ReplayingTypeValidationContext validationContext = new ReplayingTypeValidationContext();
        TypeAnnotationMetadata annotationMetadata = this.typeAnnotationMetadataStore.getTypeAnnotationMetadata(publicType);
        annotationMetadata.visitValidationFailures(validationContext);
        for (TypeAnnotationHandler typeAnnotationHandler : this.typeAnnotationHandlers) {
            if (!annotationMetadata.isAnnotationPresent(typeAnnotationHandler.getAnnotationType())) continue;
            typeAnnotationHandler.validateTypeMetadata(publicType, validationContext);
        }
        ImmutableSet.Builder effectiveProperties = ImmutableSet.builderWithExpectedSize((int)annotationMetadata.getPropertiesAnnotationMetadata().size());
        for (PropertyAnnotationMetadata propertyAnnotationMetadata : annotationMetadata.getPropertiesAnnotationMetadata()) {
            ImmutableMap<AnnotationCategory, Annotation> propertyAnnotations = propertyAnnotationMetadata.getAnnotations();
            Class<? extends Annotation> propertyType = this.propertyTypeResolver.resolveAnnotationType((Map<AnnotationCategory, Annotation>)propertyAnnotations);
            if (propertyType == null) {
                validationContext.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.MISSING_ANNOTATION)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> "is missing " + this.displayName)).happensBecause("A property without annotation isn't considered during up-to-date checking")).addPossibleSolution(() -> "Add " + this.displayName)).addPossibleSolution("Mark it as @Internal")).documentedAt("validation_problems", "missing_annotation"));
                continue;
            }
            PropertyAnnotationHandler annotationHandler = (PropertyAnnotationHandler)this.propertyAnnotationHandlers.get(propertyType);
            if (annotationHandler == null) {
                validationContext.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.ANNOTATION_INVALID_IN_CONTEXT)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("is annotated with invalid property type @%s", propertyType.getSimpleName()))).happensBecause(() -> "The '@" + propertyType.getSimpleName() + "' annotation cannot be used in this context")).addPossibleSolution("Remove the property")).addPossibleSolution(() -> "Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations((ImmutableSet<Class<? extends Annotation>>)this.propertyAnnotationHandlers.keySet()))).documentedAt("validation_problems", "annotation_invalid_in_context"));
                continue;
            }
            ImmutableSet<Class<? extends Annotation>> allowedModifiersForPropertyType = annotationHandler.getAllowedModifiers();
            for (Map.Entry entry : propertyAnnotations.entrySet()) {
                AnnotationCategory annotationCategory = (AnnotationCategory)entry.getKey();
                if (annotationCategory == AnnotationCategory.TYPE) continue;
                Class<? extends Annotation> annotationType = ((Annotation)entry.getValue()).annotationType();
                if (!allowedModifiersForPropertyType.contains(annotationType)) {
                    validationContext.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.INCOMPATIBLE_ANNOTATIONS)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> "is annotated with @" + annotationType.getSimpleName() + " but that is not allowed for '" + propertyType.getSimpleName() + "' properties")).happensBecause(() -> "This modifier is used in conjunction with a property of type '" + propertyType.getSimpleName() + "' but this doesn't have semantics")).withLongDescription(() -> "The list of allowed modifiers for '" + propertyType.getSimpleName() + "' is " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers))).addPossibleSolution(() -> "Remove the '@" + annotationType.getSimpleName() + "' annotation")).documentedAt("validation_problems", "incompatible_annotations"));
                    continue;
                }
                if (this.allowedPropertyModifiers.contains(annotationType)) continue;
                validationContext.visitPropertyProblem(problem2 -> ((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)((PropertyProblemBuilder)problem2.withId(ValidationProblemId.ANNOTATION_INVALID_IN_CONTEXT)).forProperty(propertyAnnotationMetadata.getPropertyName()).reportAs(Severity.ERROR)).withDescription(() -> String.format("is annotated with invalid modifier @%s", annotationType.getSimpleName()))).happensBecause(() -> "The '@" + annotationType.getSimpleName() + "' annotation cannot be used in this context")).addPossibleSolution("Remove the annotation")).addPossibleSolution(() -> "Use a different annotation, e.g one of " + DefaultTypeMetadataStore.toListOfAnnotations(this.allowedPropertyModifiers))).documentedAt("validation_problems", "annotation_invalid_in_context"));
            }
            DefaultPropertyMetadata property2 = new DefaultPropertyMetadata(propertyType, propertyAnnotationMetadata);
            annotationHandler.validatePropertyMetadata(property2, validationContext);
            if (!annotationHandler.isPropertyRelevant()) continue;
            effectiveProperties.add((Object)property2);
        }
        return new DefaultTypeMetadata((ImmutableSet<PropertyMetadata>)effectiveProperties.build(), validationContext, this.propertyAnnotationHandlers);
    }

    private static String toListOfAnnotations(ImmutableSet<Class<? extends Annotation>> classes) {
        return classes.stream().map(Class::getSimpleName).map(s -> "@" + s).sorted().collect(DefaultTypeMetadataStore.forDisplay());
    }

    private static Collector<? super String, ?, String> forDisplay() {
        return Collectors.collectingAndThen(Collectors.toList(), stringList -> {
            if (stringList.isEmpty()) {
                return "";
            }
            if (stringList.size() == 1) {
                return (String)stringList.get(0);
            }
            int bound = stringList.size() - 1;
            return String.join((CharSequence)", ", stringList.subList(0, bound)) + " or " + (String)stringList.get(bound);
        });
    }

    private static class DefaultPropertyMetadata
    implements PropertyMetadata {
        private final Class<? extends Annotation> propertyType;
        private final PropertyAnnotationMetadata annotationMetadata;

        public DefaultPropertyMetadata(Class<? extends Annotation> propertyType, PropertyAnnotationMetadata annotationMetadata) {
            this.propertyType = propertyType;
            this.annotationMetadata = annotationMetadata;
        }

        @Override
        public String getPropertyName() {
            return this.annotationMetadata.getPropertyName();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.annotationMetadata.isAnnotationPresent(annotationType);
        }

        @Override
        @Nullable
        public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
            return this.annotationMetadata.getAnnotation(annotationType);
        }

        @Override
        @Nullable
        public Optional<Annotation> getAnnotationForCategory(AnnotationCategory category) {
            return Optional.ofNullable((Annotation)this.annotationMetadata.getAnnotations().get((Object)category));
        }

        @Override
        public boolean hasAnnotationForCategory(AnnotationCategory category) {
            return this.annotationMetadata.getAnnotations().get((Object)category) != null;
        }

        @Override
        public Class<? extends Annotation> getPropertyType() {
            return this.propertyType;
        }

        @Override
        public TypeToken<?> getDeclaredType() {
            return this.annotationMetadata.getDeclaredType();
        }

        @Override
        @Nullable
        public Object getPropertyValue(Object object) {
            return this.annotationMetadata.getPropertyValue(object);
        }

        public String toString() {
            return String.format("@%s %s", this.propertyType.getSimpleName(), this.getPropertyName());
        }
    }

    private static class DefaultTypeMetadata
    implements TypeMetadata {
        private final ImmutableSet<PropertyMetadata> propertiesMetadata;
        private final ReplayingTypeValidationContext validationProblems;
        private final ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers;

        DefaultTypeMetadata(ImmutableSet<PropertyMetadata> propertiesMetadata, ReplayingTypeValidationContext validationProblems, ImmutableMap<Class<? extends Annotation>, ? extends PropertyAnnotationHandler> annotationHandlers) {
            this.propertiesMetadata = propertiesMetadata;
            this.validationProblems = validationProblems;
            this.annotationHandlers = annotationHandlers;
        }

        @Override
        public void visitValidationFailures(@Nullable String ownerPropertyPath, TypeValidationContext validationContext) {
            this.validationProblems.replay(ownerPropertyPath, validationContext);
        }

        @Override
        public Set<PropertyMetadata> getPropertiesMetadata() {
            return this.propertiesMetadata;
        }

        @Override
        public boolean hasAnnotatedProperties() {
            return !this.propertiesMetadata.isEmpty();
        }

        @Override
        public PropertyAnnotationHandler getAnnotationHandlerFor(PropertyMetadata propertyMetadata) {
            return (PropertyAnnotationHandler)this.annotationHandlers.get(propertyMetadata.getPropertyType());
        }
    }
}

