/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.ObjectMetadata;
import org.gradle.internal.impldep.com.amazonaws.services.s3.model.S3Object;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;

public class S3Resource
implements ExternalResourceReadResponse {
    private final S3Object s3Object;
    private final URI uri;

    public S3Resource(S3Object s3Object, URI uri) {
        this.s3Object = s3Object;
        this.uri = uri;
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.s3Object.getObjectContent();
    }

    public URI getURI() {
        return this.uri;
    }

    public long getContentLength() {
        return this.s3Object.getObjectMetadata().getContentLength();
    }

    public boolean isLocal() {
        return false;
    }

    @Override
    public ExternalResourceMetaData getMetaData() {
        ObjectMetadata objectMetadata = this.s3Object.getObjectMetadata();
        Date lastModified = objectMetadata.getLastModified();
        return new DefaultExternalResourceMetaData(this.uri, lastModified.getTime(), this.getContentLength(), this.s3Object.getObjectMetadata().getContentType(), this.s3Object.getObjectMetadata().getETag(), null);
    }

    @Override
    public void close() throws IOException {
        this.s3Object.close();
    }
}

