/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.internal.typeconversion.UnsupportedNotationException;

public class NotationConverterToNotationParserAdapter<N, T>
implements NotationParser<N, T> {
    private final NotationConverter<? super N, ? extends T> converter;

    public NotationConverterToNotationParserAdapter(NotationConverter<? super N, ? extends T> converter) {
        this.converter = converter;
    }

    @Override
    public T parseNotation(N notation) throws TypeConversionException {
        ResultImpl result2 = new ResultImpl();
        this.converter.convert(notation, result2);
        if (!result2.hasResult) {
            throw new UnsupportedNotationException(notation);
        }
        return (T)result2.result;
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.converter.describe(visitor);
    }

    private static class ResultImpl<T>
    implements NotationConvertResult<T> {
        private boolean hasResult;
        private T result;

        private ResultImpl() {
        }

        @Override
        public boolean hasResult() {
            return this.hasResult;
        }

        @Override
        public void converted(T result2) {
            this.hasResult = true;
            this.result = result2;
        }
    }
}

