/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Namer;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultNamedDomainObjectList;
import org.gradle.api.internal.artifacts.repositories.AuthenticationSupporter;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAuthenticationContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.toolchain.JavaToolchainRepository;
import org.gradle.jvm.toolchain.JavaToolchainResolver;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainRepository;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryHandlerInternal;
import org.gradle.jvm.toolchain.internal.JavaToolchainRepositoryInternal;

public class DefaultJavaToolchainRepositoryHandler
implements JavaToolchainRepositoryHandlerInternal {
    private final DefaultNamedDomainObjectList<JavaToolchainRepository> repositories;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ProviderFactory providerFactory;
    private final AuthenticationSchemeRegistry authenticationSchemeRegistry;
    private boolean mutable = true;

    @Inject
    public DefaultJavaToolchainRepositoryHandler(Instantiator instantiator2, ObjectFactory objectFactory, ProviderFactory providerFactory, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
        this.repositories = new DefaultNamedDomainObjectList<JavaToolchainRepository>(JavaToolchainRepository.class, instantiator2, (Namer)new RepositoryNamer(), CollectionCallbackActionDecorator.NOOP){

            @Override
            public String getTypeDisplayName() {
                return "repository";
            }
        };
        this.instantiator = instantiator2;
        this.objectFactory = objectFactory;
        this.providerFactory = providerFactory;
        this.authenticationSchemeRegistry = authenticationSchemeRegistry;
    }

    @Override
    public void repository(String name, Action<? super JavaToolchainRepository> configureAction) {
        this.assertMutable();
        DefaultAuthenticationContainer authenticationContainer = new DefaultAuthenticationContainer(this.instantiator, CollectionCallbackActionDecorator.NOOP);
        for (Map.Entry e : this.authenticationSchemeRegistry.getRegisteredSchemes().entrySet()) {
            authenticationContainer.registerBinding(e.getKey(), e.getValue());
        }
        AuthenticationSupporter authenticationSupporter = new AuthenticationSupporter(this.instantiator, this.objectFactory, authenticationContainer, this.providerFactory);
        DefaultJavaToolchainRepository repository = this.objectFactory.newInstance(DefaultJavaToolchainRepository.class, name, authenticationContainer, authenticationSupporter, this.providerFactory);
        configureAction.execute(repository);
        boolean isNew = this.repositories.add(repository);
        if (!isNew) {
            throw new GradleException("Duplicate configuration for repository '" + name + "'.");
        }
    }

    @Override
    public List<JavaToolchainRepository> getAsList() {
        ArrayList copy = this.repositories.stream().map(it -> (JavaToolchainRepositoryInternal)it).map(ImmutableJavaToolchainRepository::new).collect(Collectors.toCollection(ArrayList::new));
        return Collections.unmodifiableList(copy);
    }

    @Override
    public int size() {
        return this.repositories.size();
    }

    @Override
    public boolean remove(String name) {
        this.assertMutable();
        JavaToolchainRepository repository = (JavaToolchainRepository)this.repositories.findByName(name);
        if (repository == null) {
            return false;
        }
        return this.repositories.remove(repository);
    }

    @Override
    public void preventFromFurtherMutation() {
        this.mutable = false;
    }

    private void assertMutable() {
        if (!this.mutable) {
            throw new InvalidUserCodeException("Mutation of toolchain repositories declared in settings is only allowed during settings evaluation");
        }
    }

    private static class ImmutableJavaToolchainRepository
    implements JavaToolchainRepositoryInternal {
        private final JavaToolchainRepositoryInternal delegate;

        public ImmutableJavaToolchainRepository(JavaToolchainRepositoryInternal delegate) {
            this.delegate = delegate;
        }

        @Override
        public Collection<Authentication> getConfiguredAuthentication() {
            return this.delegate.getConfiguredAuthentication();
        }

        @Override
        public PasswordCredentials getCredentials() {
            return this.delegate.getCredentials();
        }

        @Override
        public <T extends Credentials> T getCredentials(Class<T> credentialsType) {
            return this.delegate.getCredentials(credentialsType);
        }

        @Override
        public void credentials(Action<? super PasswordCredentials> action) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        @Override
        public <T extends Credentials> void credentials(Class<T> credentialsType, Action<? super T> action) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        @Override
        public void credentials(Class<? extends Credentials> credentialsType) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        @Override
        public void authentication(Action<? super AuthenticationContainer> action) {
            throw new UnsupportedOperationException("Can't modify repositories through a read-only view");
        }

        @Override
        public AuthenticationContainer getAuthentication() {
            return this.delegate.getAuthentication();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Property<Class<? extends JavaToolchainResolver>> getResolverClass() {
            return this.delegate.getResolverClass();
        }
    }

    private static class RepositoryNamer
    implements Namer<JavaToolchainRepository> {
        private RepositoryNamer() {
        }

        @Override
        public String determineName(JavaToolchainRepository repository) {
            return repository.getName();
        }
    }
}

