/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.model.internal.report.unbound.UnboundRule;
import org.gradle.model.internal.report.unbound.UnboundRulesReporter;

public class UnboundModelRulesException
extends GradleException {
    private static final String MESSAGE = "The following model rules could not be applied due to unbound inputs and/or subjects:";
    private final List<? extends UnboundRule> rules;

    public UnboundModelRulesException(List<? extends UnboundRule> rules) {
        super(UnboundModelRulesException.toMessage(rules));
        this.rules = rules;
    }

    private static String toMessage(Iterable<? extends UnboundRule> rules) {
        StringWriter string2 = new StringWriter();
        PrintWriter writer2 = new PrintWriter(string2);
        writer2.println(MESSAGE);
        writer2.println();
        new UnboundRulesReporter(writer2, "  ").reportOn(rules);
        return string2.toString();
    }

    public List<? extends UnboundRule> getRules() {
        return this.rules;
    }
}

