/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.util;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class MergeOptionsUtil {
    public static int getHeapSizeMb(String heapSize) {
        if (heapSize == null) {
            return -1;
        }
        String normalized = heapSize.trim().toLowerCase();
        try {
            if (normalized.endsWith("m")) {
                return Integer.parseInt(normalized.substring(0, normalized.length() - 1));
            }
            if (normalized.endsWith("g")) {
                return Integer.parseInt(normalized.substring(0, normalized.length() - 1)) * 1024;
            }
        }
        catch (NumberFormatException e) {
            throw new InvalidUserDataException("Cannot parse heap size: " + heapSize, e);
        }
        throw new InvalidUserDataException("Cannot parse heap size: " + heapSize);
    }

    public static String mergeHeapSize(String heapSize1, String heapSize2) {
        int mergedHeapSizeMb = Math.max(MergeOptionsUtil.getHeapSizeMb(heapSize1), MergeOptionsUtil.getHeapSizeMb(heapSize2));
        return mergedHeapSizeMb == -1 ? null : String.valueOf(mergedHeapSizeMb) + "m";
    }

    public static boolean canBeMerged(String left, String right) {
        if (left == null || right == null) {
            return true;
        }
        return MergeOptionsUtil.normalized(left).equals(MergeOptionsUtil.normalized(right));
    }

    public static boolean canBeMerged(File left, File right) {
        if (left == null || right == null) {
            return true;
        }
        return left.equals(right);
    }

    public static Set<String> normalized(@Nullable Iterable<String> strings) {
        LinkedHashSet normalized = Sets.newLinkedHashSet();
        if (strings != null) {
            for (String string2 : strings) {
                normalized.add(MergeOptionsUtil.normalized(string2));
            }
        }
        return normalized;
    }

    public static String normalized(@Nullable String string2) {
        return Strings.nullToEmpty((String)string2).trim();
    }

    public static boolean containsAll(Map<String, Object> left, Map<String, Object> right) {
        for (String rightKey : right.keySet()) {
            if (!MergeOptionsUtil.normalized(left.keySet()).contains(MergeOptionsUtil.normalized(rightKey))) {
                return false;
            }
            for (String leftKey : left.keySet()) {
                if (!MergeOptionsUtil.normalized(leftKey).equals(MergeOptionsUtil.normalized(rightKey)) || left.get(leftKey).equals(right.get(rightKey))) continue;
                return false;
            }
        }
        return true;
    }
}

