/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.security.internal;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;

public final class PGPUtils {
    private static final Field KEYS_FIELD = PGPUtils.getKeysField();

    private PGPUtils() {
    }

    public static List<String> getUserIDs(PGPPublicKey pk) {
        ArrayList<String> userIds = new ArrayList<String>();
        pk.getRawUserIDs().forEachRemaining(id -> userIds.add(new String((byte[])id, StandardCharsets.UTF_8)));
        return userIds;
    }

    public static int getSize(PGPPublicKeyRing keyring) {
        try {
            return ((List)KEYS_FIELD.get(keyring)).size();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getKeysField() {
        try {
            Field keysField = PGPPublicKeyRing.class.getDeclaredField("keys");
            keysField.setAccessible(true);
            return keysField;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

