/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.swiftpm.tasks;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeSet;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.nativeplatform.Linkage;
import org.gradle.swiftpm.Package;
import org.gradle.swiftpm.internal.AbstractProduct;
import org.gradle.swiftpm.internal.BranchDependency;
import org.gradle.swiftpm.internal.DefaultLibraryProduct;
import org.gradle.swiftpm.internal.DefaultPackage;
import org.gradle.swiftpm.internal.DefaultTarget;
import org.gradle.swiftpm.internal.Dependency;
import org.gradle.swiftpm.internal.VersionDependency;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class GenerateSwiftPackageManagerManifest
extends DefaultTask {
    private final RegularFileProperty manifestFile;
    private final Property<Package> packageProperty;

    public GenerateSwiftPackageManagerManifest() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.manifestFile = objectFactory.fileProperty();
        this.packageProperty = objectFactory.property(Package.class);
    }

    @Input
    public Property<Package> getPackage() {
        return this.packageProperty;
    }

    @OutputFile
    public RegularFileProperty getManifestFile() {
        return this.manifestFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void generate() {
        DefaultPackage srcPackage = (DefaultPackage)this.packageProperty.get();
        Path manifest = ((RegularFile)this.manifestFile.get()).getAsFile().toPath();
        try {
            Path baseDir = manifest.getParent();
            Files.createDirectories(baseDir, new FileAttribute[0]);
            try (PrintWriter writer2 = new PrintWriter(Files.newBufferedWriter(manifest, Charset.forName("utf-8"), new OpenOption[0]));){
                writer2.println("// swift-tools-version:4.0");
                writer2.println("//");
                writer2.println("// GENERATED FILE - do not edit");
                writer2.println("//");
                writer2.println("import PackageDescription");
                writer2.println();
                writer2.println("let package = Package(");
                writer2.println("    name: \"" + this.getProject().getName() + "\",");
                writer2.println("    products: [");
                for (AbstractProduct product : srcPackage.getProducts()) {
                    if (product.isExecutable()) {
                        writer2.print("        .executable(");
                        writer2.print("name: \"");
                        writer2.print(product.getName());
                        writer2.print("\"");
                    } else {
                        writer2.print("        .library(");
                        writer2.print("name: \"");
                        writer2.print(product.getName());
                        DefaultLibraryProduct library = (DefaultLibraryProduct)product;
                        if (library.getLinkage() == Linkage.SHARED) {
                            writer2.print("\", type: .dynamic");
                        } else {
                            writer2.print("\", type: .static");
                        }
                    }
                    writer2.print(", targets: [\"");
                    writer2.print(product.getTarget().getName());
                    writer2.println("\"]),");
                }
                writer2.println("    ],");
                if (!srcPackage.getDependencies().isEmpty()) {
                    writer2.println("    dependencies: [");
                    for (Dependency dependency : srcPackage.getDependencies()) {
                        writer2.print("        .package(url: \"");
                        if (dependency.getUrl().getScheme().equals("file")) {
                            writer2.print(baseDir.relativize(new File(dependency.getUrl()).toPath()));
                        } else {
                            writer2.print(dependency.getUrl());
                        }
                        writer2.print("\", ");
                        if (dependency instanceof VersionDependency) {
                            VersionDependency versionDependency = (VersionDependency)dependency;
                            if (versionDependency.getUpperBound() == null) {
                                writer2.print("from: \"");
                                writer2.print(versionDependency.getLowerBound());
                                writer2.print("\"");
                            } else if (versionDependency.isUpperInclusive()) {
                                writer2.print("\"");
                                writer2.print(versionDependency.getLowerBound());
                                writer2.print("\"...\"");
                                writer2.print(versionDependency.getUpperBound());
                                writer2.print("\"");
                            } else {
                                writer2.print("\"");
                                writer2.print(versionDependency.getLowerBound());
                                writer2.print("\"..<\"");
                                writer2.print(versionDependency.getUpperBound());
                                writer2.print("\"");
                            }
                        } else {
                            writer2.print(".branch(\"");
                            writer2.print(((BranchDependency)dependency).getBranch());
                            writer2.print("\")");
                        }
                        writer2.println("),");
                    }
                    writer2.println("    ],");
                }
                writer2.println("    targets: [");
                for (DefaultTarget target : srcPackage.getTargets()) {
                    writer2.println("        .target(");
                    writer2.print("            name: \"");
                    writer2.print(target.getName());
                    writer2.println("\",");
                    if (!target.getRequiredTargets().isEmpty() || !target.getRequiredProducts().isEmpty()) {
                        writer2.println("            dependencies: [");
                        for (String dep : target.getRequiredTargets()) {
                            writer2.print("                .target(name: \"");
                            writer2.print(dep);
                            writer2.println("\"),");
                        }
                        for (String dep : target.getRequiredProducts()) {
                            writer2.print("                .product(name: \"");
                            writer2.print(dep);
                            writer2.println("\"),");
                        }
                        writer2.println("            ],");
                    }
                    writer2.print("            path: \"");
                    Path productPath = target.getPath().toPath();
                    String relPath = baseDir.relativize(productPath).toString();
                    writer2.print(relPath.isEmpty() ? "." : relPath);
                    writer2.println("\",");
                    writer2.println("            sources: [");
                    TreeSet<String> sorted = new TreeSet<String>();
                    for (File sourceFile : target.getSourceFiles()) {
                        sorted.add(productPath.relativize(sourceFile.toPath()).toString());
                    }
                    for (String sourcePath : sorted) {
                        writer2.print("                \"");
                        writer2.print(sourcePath);
                        writer2.println("\",");
                    }
                    writer2.print("            ]");
                    if (target.getPublicHeaderDir() != null) {
                        writer2.println(",");
                        writer2.print("            publicHeadersPath: \"");
                        writer2.print(productPath.relativize(target.getPublicHeaderDir().toPath()));
                        writer2.print("\"");
                    }
                    writer2.println();
                    writer2.println("        ),");
                }
                writer2.print("    ]");
                if (srcPackage.getSwiftLanguageVersion() != null) {
                    writer2.println(",");
                    writer2.print("    swiftLanguageVersions: [");
                    writer2.print(srcPackage.getSwiftLanguageVersion().getVersion());
                    writer2.print("]");
                }
                writer2.println();
                writer2.println(")");
            }
        }
        catch (IOException e) {
            throw new GradleException(String.format("Could not write manifest file %s.", manifest), e);
        }
    }
}

