/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.dataAccess;

import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.FieldCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.NameCoverageDataAccess;
import com.intellij.rt.coverage.util.OptionsUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public class DataAccessUtil {
    public static final String HITS_ARRAY_TYPE = "[I";
    public static final String TEST_MASK_ARRAY_TYPE = "[Z";
    public static final String CLASS_DATA_NAME = "__$classData$__";

    public static CoverageDataAccess createTestTrackingDataAccess(String className, ClassReader cr, boolean isArray) {
        if (OptionsUtil.NEW_BRANCH_COVERAGE_ENABLED) {
            return new FieldCoverageDataAccess(cr, className, isArray ? DataAccessUtil.createTestTrackingArrayInit(className) : DataAccessUtil.createTestTrackingInit(className));
        }
        return new NameCoverageDataAccess(DataAccessUtil.createTestTrackingInit(className));
    }

    private static CoverageDataAccess.Init createTestTrackingInit(String className) {
        return new CoverageDataAccess.Init(CLASS_DATA_NAME, "Ljava/lang/Object;", "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", new Object[]{className});
    }

    private static CoverageDataAccess.Init createTestTrackingArrayInit(String className) {
        return new CoverageDataAccess.Init("__$traceMask$__", TEST_MASK_ARRAY_TYPE, "com/intellij/rt/coverage/data/ProjectData", "getTraceMask", "(Ljava/lang/String;)[Z", new Object[]{className});
    }
}

