/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import com.intellij.rt.coverage.util.ClassNameUtil;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class NotNullAssertionsFilter
extends BranchesFilter {
    private static final byte SEEN_NOTHING = 0;
    private static final byte DUP_SEEN = 1;
    private static final byte IFNONNULL_SEEN = 2;
    private static final byte PARAM_CONST_SEEN = 3;
    private static final byte ASSERTIONS_DISABLED_STATE = 5;
    private byte myState;
    private boolean myHasLines;

    public void initFilter(MethodVisitor mv, Instrumenter context, BranchDataContainer branchData) {
        super.initFilter(mv, context, branchData);
        this.myState = 0;
        this.myHasLines = false;
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.myHasLines = true;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (!this.myHasLines) {
            return;
        }
        if (this.myState == 5 && opcode == 154) {
            this.myState = 0;
            if (this.myBranchData.getJump(label) != null) {
                this.myBranchData.removeLastJump();
            }
        }
        this.myState = this.myState == 1 && opcode == 199 ? (byte)2 : (byte)0;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        if (!this.myHasLines) {
            return;
        }
        this.myState = opcode == 89 ? (byte)1 : (this.myState == 2 && (opcode >= 3 && opcode <= 8 || opcode == 16 || opcode == 17) ? (byte)3 : (byte)0);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        if (!this.myHasLines) {
            return;
        }
        this.myState = opcode == 178 && name.equals("$assertionsDisabled") ? (byte)5 : (byte)0;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (!this.myHasLines) {
            return;
        }
        if (this.myState == 3 && opcode == 184 && name.startsWith("$$$reportNull$$$") && ClassNameUtil.convertToFQName(owner).equals(this.myContext.getClassName())) {
            this.myBranchData.removeLastJump();
        }
        this.myState = 0;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        this.setSeenNothingState();
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        this.setSeenNothingState();
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        this.setSeenNothingState();
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.setSeenNothingState();
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        this.setSeenNothingState();
    }

    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        this.setSeenNothingState();
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        this.setSeenNothingState();
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        super.visitMultiANewArrayInsn(desc, dims);
        this.setSeenNothingState();
    }

    private void setSeenNothingState() {
        if (this.myHasLines) {
            this.myState = 0;
        }
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return true;
    }
}

