/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.util;

import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.commons.LocalVariablesSorter;

public class LocalVariableInserter
extends LocalVariablesSorter {
    private final String myVariableName;
    private final String myVariableType;
    private int myVariableIndex = -1;
    private Label myStartLabel;
    private Label myEndLabel;

    public LocalVariableInserter(MethodVisitor methodVisitor, int access, String descriptor, String variableName, String variableType) {
        super(589824, access, descriptor, methodVisitor);
        this.myVariableName = variableName;
        this.myVariableType = variableType;
    }

    public void visitLabel(Label label) {
        if (this.myStartLabel == null) {
            this.myStartLabel = label;
        }
        this.myEndLabel = label;
        super.visitLabel(label);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.myStartLabel != null && this.myEndLabel != null) {
            this.mv.visitLocalVariable(this.myVariableName, this.myVariableType, null, this.myStartLabel, this.myEndLabel, this.getLVIndex());
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    public int getLVIndex() {
        if (this.myVariableIndex == -1) {
            this.myVariableIndex = this.newLocal(Type.getType(this.myVariableType));
        }
        return this.myVariableIndex;
    }
}

